function expstruct = get_experiments(filename)

fid = fopen('/tmp/script','w');
fprintf(fid, 'grep ''^EXP'' %s > /tmp/exp\n', filename);
fprintf(fid, 'grep ''^[0-9]'' %s > /tmp/data\n', filename);
fclose(fid);
!sh /tmp/script

% get key/value pairs
[junk, def_exp, def_key, def_value] = ...
	textread('/tmp/exp', '%s %d %s %s');

propList = {};
s = struct('type','experiment');
for i = 1:length(def_key),
	key = char(def_key(i));
	keyNum = strcat(key,'Num');
	if (isfield(s, key)),
		tmp = getfield(s, key);
		tmpNum = getfield(s, keyNum);
	else
		tmp = [];
		tmpNum = [];
	end
	tmp = [tmp; def_value(i)];
	value = sscanf(char(def_value(i)), '%d');
	tmpNum = [tmpNum; value];
	s = setfield(s, key, tmp);
	s = setfield(s, keyNum, tmpNum);
	propList{i,1} = key;
end

% figure out the set of values of each property
s.propList = unique(propList);
for i = 1:length(s.propList),
	property = s.propList{i};
	s.propList{i,2} = unique(getfield(s, property));
end

% now go get the real data

[data_exp, data_requests, data_time, junk] = ...
	textread('/tmp/data', '%d %d %f %d');

% for each experiment, compute a single mean (and cv)
s.timePerRequest = [];
s.timePerConnection = [];
s.meanTime = [];
s.meanPerRequest = [];
s.meanPerConnection = [];
s.cv = [];
s.requests = [];
s.times = cell(length(s.experimentIDNum),1);

ue = unique(data_exp);
for uei = 1:length(ue),
	expnum = ue(uei);
	samplesi = find(data_exp==expnum);
	times = data_time(samplesi);
	expi = find(s.experimentIDNum==expnum);

	s.requests(expi) = data_requests(samplesi(1));

	times = times(2:end);
		% disregard first time, it's always bogus
	s.times(expi,1) = {times};

	s.meanTime(expi,1) = mean(times);
	s.timePerRequest(expi,1:length(times)) = times./s.requests(expi);
	s.meanPerRequest(expi,1) = mean(times./s.requests(expi));
	if (isfield(s, 'numberOfConnectionsNum')),
		s.timePerConnection(expi,1:length(times)) = times./s.numberOfConnectionsNum(expi);
		s.meanPerConnection(expi,1) = mean(times./s.numberOfConnectionsNum(expi));
	end

	s.cv(expi,1) = std(times)/s.meanTime(expi);
end

expstruct = s;

return;
