function [column] = extractColumn(aggexp, rownames, colname1, colname2)
% extract a column from a series of rows from an aggregate experiment created
% by 'present'.

column = [];
for j=1:length(rownames),
	rowjname = rownames(j);
	found = 0;
	for i=1:length(aggexp),
		if (isfield(aggexp(i).summary, rowjname)),
			exp = aggexp(i).summary;
			inrow = getfield(exp, char(rowjname));
			outrow = [];
			setfield(outrow, 'name', rownames(j));
			col = getfield(inrow, colname1, colname2);
			if (ischar(col)),
				column = strvcat(column, col);
			else
				column = [column; col];
			end
			found = 1;
			break;	% go get next row
		end
	end
	if (~found),
		error(['base ',char(rowjname),' not found']);
	end
end
% disp(sprintf('%s %s %s', char(rowjname), char(colname1), char(colname2)));
% column
