p_context = 1;
p_session = 2;
p_connect = 3;
p_request = 4;
p_mb = 5;

labels = repmat({''},17,1);
cf_apachelocal = 1;
labels(1) = {'Apache local'};
cf_apacheremote = 3;
labels(5) = {'Apache remote'};
cf_jettylocal = 5;
labels(3) = {'Jetty local'};
cf_jettyremote = 7;
labels(7) = {'Jetty remote'};
cf_apachessl = 9;
labels(9) = {'Apache SSL'};

data = [
p_connect,	cf_apachelocal,		experiment(10).polys(1).y_intercept;
p_request,	cf_apachelocal,		experiment(10).polys(1).slope;
%p_mb,		cf_apachelocal,		experiment(3).polys(1).slope;
p_connect,	cf_apacheremote,	experiment(11).polys(1).y_intercept;
p_request,	cf_apacheremote,	experiment(11).polys(1).slope;
%p_mb,		cf_apacheremote,	experiment(4).polys(1).slope;
p_connect,	cf_jettylocal,		experiment(10).polys(3).y_intercept;
p_request,	cf_jettylocal,		experiment(10).polys(3).slope;
%p_mb,		cf_jettylocal,		experiment(3).polys(3).slope;
p_connect,	cf_jettyremote,		experiment(11).polys(3).y_intercept;
p_request,	cf_jettyremote,		experiment(11).polys(3).slope;
%p_mb,		cf_jettyremote,		experiment(4).polys(3).slope;
p_context,	cf_apachessl,		experiment(5).polys(3).y_intercept-experiment(5).polys(2).y_intercept;
p_session,	cf_apachessl,		experiment(5).polys(2).y_intercept-experiment(5).polys(1).y_intercept;
p_connect,	cf_apachessl,		experiment(5).polys(1).y_intercept;
p_request,	cf_apachessl,		experiment(8).polys(1).slope;
];

clear params;
%params.zlim = 400;
params.depth_labels = strvcat(labels);
bar_graph(data, params);

set(gca,'xtick',[p_context, p_session, p_connect, p_request]);
set(gca,'xticklabel', ...
	strvcat('context','session','connect','request','per MB'));
