package ssh.RSA;

import ssh.*;
import ssh.RSA.*;
import java.math.*;

/**
 * Routines to test my RSAKey implementation.
 */
public class test {
	public static void main(String[] args) {
		SshRandom random = new SshRandom();
		RSAKey pair[] = Keygen.generateKeys(1024, random);

		/*
		System.out.println("private key: exp "+pair[0].exponent);
		System.out.println("private key: mod "+pair[0].modulus);
		System.out.println("public  key: exp "+pair[1].exponent);
		System.out.println("public  key: mod "+pair[1].modulus);
		*/

		byte[] input = random.newByteArray(6);
		
		BigInteger pad = pair[0].randomPad(input, 0, input.length, random);
		System.out.println("pad_16 = "+pad.toString(16));
		BigInteger enc = pair[0].cryptBasic(pad);
		System.out.println("enc_16 = "+enc.toString(16));
		BigInteger dec = pair[1].cryptBasic(enc);
		System.out.println("dec_16 = "+dec.toString(16));
		byte[] output = pair[1].unpad(dec);
		if (output == null) {
			System.out.println("decryption failed!");
		} else if (output.length!=input.length) {
			System.out.println("decrypted "+output.length+" bytes, expected "
				+input.length);
		} else {
			for (int i=0; i<input.length; i++) {
				if (input[i] != output[i]) {
					System.out.println("output["+i+"]="+output[i]
						+" != input["+i+"]="+input[i]);
				}
			}
		}
	}

	void dump(byte[] a) {
		for (int i=0; i<a.length; i++) {
			System.out.print((((int)a[i])&0xff)+" ");
		}
		System.out.println();
	}
}
