package servlet;

import java.io.*;
import java.net.*;
import com.mortbay.HTTP.*;
import com.mortbay.Util.*;
import COM.claymoresystems.cert.*;
import COM.claymoresystems.ptls.*;
import COM.claymoresystems.sslg.*;

/**
 * An SSL listener for mortbay's Jetty webserver. By instantiating this
 * instead of HttpListener, you get SSL sockets. This class uses
 * claymoresystems' SSL implementation.<p>
 *
 * Originally written to provide a Java-SSL-client to Java-SSL-server
 * performance baseline for comparison to Snowflake authorization.
 *
 * @todo Adapt to implement Sf-over-SSL. That would make for a better
 * performance comparison, plus it would make different and interesting
 * security/performance tradeoffs relative to the signed-requests protocol.
 */
public class SSLListener extends NaglessListener {
	SSLContext context;

	/**
	 * This is the only constructor that matters; that is, this is the
	 * one HttpServer calls when instantiating these critters. It's
	 * defined by HttpListener.ConstructArgs.
	 */
	public SSLListener(InetAddrPort addrPort, HttpServer httpServer,
		int minThreads, int maxThreads, int maxIdleTimeMs)
		throws IOException {
		super(addrPort, httpServer, minThreads, maxThreads, maxIdleTimeMs);

		// need to extract our SSLContext from the HttpServer
		context = ((SSLConfiguration) httpServer.configuration())
			.getSSLContext();
	}

    /** New server socket.
     * Creates a new servers socket. May be overridden by derived class
     * to create specialist serversockets (eg SSL).
     * @param address Address and port
     * @param acceptQueueSize Accept queue size
     * @return The new ServerSocket
     * @exception java.io.IOException 
     */
    protected ServerSocket newServerSocket(InetAddrPort address,
                                           int acceptQueueSize)
         throws java.io.IOException
    {
        if (address==null) {
            return new SSLServerSocket(context, 0,acceptQueueSize);
		}

        return new SSLServerSocket(context, address.getPort(),
                                acceptQueueSize,
                                address.getInetAddress());
    }
}
