package rmi;

import java.io.IOException;
import java.io.ObjectOutput;
import java.rmi.*;
import java.rmi.server.*;
import java.security.*;
import sun.rmi.server.*;
import sun.rmi.transport.*;
import sun.rmi.transport.tcp.*;

/**
 * Server-side ref for a sf remote impl. Replaces getClientRef()
 * with one with a retrying invoke() method.
 *
 * @deprecated This was an attempt to replumb RMI as I did once in the
 * {@link sf.rmi} package; I eventually took the shortcut described
 * in {@link InvokeHack}.
 *
 * @todo NOT FOR DISTRIBUTION
 * The code in this class is based on/copied from Sun's class.
 * @classSummaryOnly true
 */
public class SfServerRef
	extends UnicastServerRef2 {

	// LiveRef myCopyOfRef;

	/**
	 * All ctors defer to superclass
	 */
	public SfServerRef() {
		super();
		System.err.println("Crud -- no LiveRef");
	}

	public SfServerRef(LiveRef ref) {
		super(ref);
		// myCopyOfRef = ref;
	}

	public SfServerRef(int port,
							 RMIClientSocketFactory csf,
							 RMIServerSocketFactory ssf) {
		this(new LiveRef(port, csf,ssf));
	}

	/**
	 * Returns the class of the ref type to be serialized
	 */
	public String getRefClass(ObjectOutput out)
	{
		String x = super.getRefClass(out);
			// Super will throw an exception if this class
			// shouldn't be marshaled.
		return "SfServerRef";
	}

	/**
	 * Return the client remote reference for this remoteRef.
	 * In the case of a client RemoteRef "this" is the answer.
	 * For a server remote reference, a client side one will have to
	 * found or created.
	 */
	protected RemoteRef getClientRef() {
		AccessControlContext acc = AccessController.getContext();
		return new SfUnicastRef(ref);
	}

//	protected void setRef(LiveRef ref) {
//		this.ref = ref;
//	}
}
