package relational.email;

import java.awt.event.*;

/**
 * A state of the CommandPanel state machine. Concrete subclasses
 * are defined inside {@link CommandPanel}.
 */
public abstract class State {
	public State() {}
		// you must declare a public constructor so I can create you.
	public abstract void keyTyped(KeyEvent e);
		// what to do if user types a key while in this state.

	// optional methods
	public void enterState() {}
		// what to do upon entering this state.
}
