package relational;

import java.net.*;
import java.rmi.*;

/**
 * See if an RMI Database is accessible by trying to
 * invoke its noop method. Written when I was trying to
 * get SSL to work.
 */
public class CheckDatabase {
	public static void main(String argv[]) {
		try {
			if (System.getSecurityManager()==null) {
				System.setSecurityManager(new RMISecurityManager());
			}

			InetAddress thisHost = InetAddress.getLocalHost();
			Database db = (Database)
				Naming.lookup("//"+thisHost.getHostName()+"/RMIDatabase");
			db.noop();
			System.err.println("Well, noop seems to have worked.");
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
