package proof;

import sdsi.*;
import sdsi.sexp.*;
import Tools.*;

import java.security.*;
import java.util.*;

/**
 * @deprecated This class was an attempt to use the logical conclusion {@tex
 * B \speaksfor B|A} that the logic does not support. Good thing we
 * have the logic.
 */
public class QuotingRule
	extends Proof {

	Quoting issuer;
	Subject subject;

	static final String LABEL = "quoting-rule";

	public QuotingRule(SexpList list)
		throws SexpParseException {
		if (!(list.getType().equals(Proof.LABEL)
				&& ((SexpString) list.elementAt(1)).stringContent()
					.equals(TwoStepProof.LABEL)
				&& list.size()==4
				&& (list.elementAt(2) instanceof SexpList)
				&& (list.elementAt(3) instanceof SexpList)
			)) {
			throw new SexpParseException(	
				"incorrectly formatted "+LABEL+" proof");
		}
		issuer = (Quoting) KeyTools.parseSexp(list.elementAt(2));
		subject = (Subject) KeyTools.parseSexp(list.elementAt(3));
		srep = list;
	}

	public QuotingRule(Quoting issuer, Subject subject) {
		this.issuer = issuer;
		this.subject = subject;
		Sexp[] sexpary = new Sexp[4];
		sexpary[0] = new SexpString(Proof.LABEL);
		sexpary[1] = new SexpString(QuotingRule.LABEL);
		sexpary[2] = issuer.getSrep();
		sexpary[3] = subject.getSrep();
		srep = new SexpList(sexpary);
	}

	public SDSIPrincipal getIssuer() {
		return issuer;
	}

	public Subject getSubject() {
		return subject;
	}

	/**
	 * verify that the proof steps are indeed valid, and that they
	 * combine as advertised to show the claimed result
	 */
	protected void directVerify()
		throws InvalidProofException {
		if (!KeyTools.arePrincipalsEquivalent(
			(SDSIPrincipal) issuer.getQuoter(), (SDSIPrincipal) subject)) {
			throw new InvalidProofException(
				"QuotingRule used incorrectly: subject isn't the quoter.");
		}
	}

	void preorder(List addToMe, int what) {
		switch (what) {
			case Proof.ISSUERS:
				addToMe.add(getIssuer());
				break;
			case Proof.CERTIFICATES:
				break;
			case Proof.PROOFS:
				addToMe.add(this);
				break;
			default:
				throw new RuntimeException("undefined what.");
		}
	}

	public Tag getTag() {
		return Tag.getTagStar();
	}

// Bonehead: I'm a SDSIObject; these are already implemented well.
//	public boolean equals(Object o) {
//		if (!(o instanceof QuotingRule)) {
//			return false;
//		}
//		QuotingRule qr = (QuotingRule) o;
//		return qr.issuer.equals(issuer) && qr.subject.equals(subject);
//	}
//
//	public int hashCode() {
//		return issuer.hashCode()^subject.hashCode();
//	}
}
