package jp;

import com.mortbay.Base.*;
import com.mortbay.Util.*;
import com.mortbay.HTTP.*;
import com.mortbay.HTTP.Handler.*;
import com.mortbay.HTTP.Configure.*;
import java.io.*;
import java.net.*;
import javax.servlet.*;
import java.util.*;

import Tools.*;

/**
 * A Jetty configuration class that sets up a servlet server,
 * the secure (Snowflake-HTTP) file servlet,
 * and the secure mail gateway.
 */
public class SecureServerConfig
	extends com.mortbay.HTTP.Configure.BaseConfiguration {
    
	/**
	 * Create a configuration bound at the given host address and port.
	 */
    public SecureServerConfig(Options opts)
         throws IOException
    {
        // Listen at a single port on the localhost
        addresses=new InetAddrPort[1];
        addresses[0]=new InetAddrPort(null,opts.getInt("port"));

        // Create single stack of HttpHandlers at "/"
        httpHandlersMap=new PathMap();
        HttpHandler[] httpHandlers = new HttpHandler[5];
        httpHandlersMap.put("/",httpHandlers);
        int h=0;

        // Parameter handler
        httpHandlers[h++] = new SessionHandler();
        
        // Parameter handler
        httpHandlers[h++] = new ParamHandler();
        
        Properties properties;

        // File Servlet Handler
        properties = new Properties();
        properties.put("SERVLET.Files.PATHS",opts.get("filePath"));
        properties.put("SERVLET.Files.CLASSPATH",opts.get("classPath"));
        properties.put("SERVLET.Files.CLASS", "servlet.FileServlet");
//        properties.put("SERVLET.Files.PROPERTY.protectedServerPrincipal",
//			opts.get("publicKey"));
        properties.put("SERVLET.Files.PROPERTY.root",
			opts.get("root"));
        httpHandlers[h++] = new ServletHandler(properties);

        // Mail Servlet Handler
        properties = new Properties();
        properties.put("SERVLET.Mail.PATHS",opts.get("mailPath"));
        properties.put("SERVLET.Mail.CLASSPATH",opts.get("classPath"));
        properties.put("SERVLET.Mail.CLASS", "servlet.MailServlet");
//        properties.put("SERVLET.Mail.PROPERTY.protectedServerPrincipal",
//			opts.get("publicKey"));
        properties.put("SERVLET.Mail.PROPERTY.root",
			opts.get("root"));
        properties.put("SERVLET.Mail.PROPERTY.noClassLoader", "true");
			// make the dang thing debuggable by stupid jdb
        httpHandlers[h++] = new ServletHandler(properties);

        // NotFound Handler
        httpHandlers[h++] = new NotFoundHandler();
    }

	/**
	 * Override a default mortbay method to supply {@link
	 * servlet.NaglessListener} listeners to handle requests.
	 */
	public Class[] listenerClasses() {
		Class[] classArray = new Class[addresses.length];
		java.util.Arrays.fill(classArray, servlet.NaglessListener.class);
		return classArray;
	}

	/**
	 * Start the servlet server and servlets from the Unix command
	 * line.
	 */
    public static void main(String args[]) {
		Options opts = new Options(args) {
			public void defineOptions() {
				programName = "SecureServerConfig";
//				defineArgument(
//		"publicKey", true,
//		"The public key that owns this service (an s-expression or filename)",
//		null);
				defineArgument(
		"port", false, "Port number server listens on", "8041");
				defineArgument(
		"filePath", false, "What path the file servlet appears under?", "/files/");
				defineArgument(
		"mailPath", false, "What path the mail servlet appears under?", "/mail/");
				defineArgument(
		"classPath", false, "CLASSPATH at which to locate servlet code", ".");
				defineOption(
		"root", "Root of web directory tree", ".");
			}
		};
        try{        
            SecureServerConfig servletServer =
                new SecureServerConfig(opts);

            HttpServer httpServer = new HttpServer(servletServer);
            httpServer.join();
        }
        catch(Exception e){
            Code.warning(e);
        }
    }
};
