#include <sys/time.h>
#include <sys/times.h>
#include <unistd.h>
#include <limits.h>
#include <time.h>

#include <jni.h>
#include <stdio.h>

#include "Tools_Timer.h"

extern "C" {

JNIEXPORT jlongArray JNICALL Java_Tools_Timer_syscallTimes
  (JNIEnv *env, jclass self)
{
	/* get the time info */
	struct tms ttime;
	times(&ttime);

#ifdef SOLARIS_DONT_USE
	struct timespec ts;
	clock_gettime(CLOCK_REALTIME, &ts);
#else	/* is this portable? It works on linux: */
	struct timeval ts;
	gettimeofday(&ts, NULL);
#endif

	/* create an array to return it in */
	jlongArray aol = env->NewLongArray(7);
	jlong buf[7];

	/* stash the data */
	env->GetLongArrayRegion(aol, 0, 7, buf);
	buf[0]=ttime.tms_utime;
	buf[1]=ttime.tms_stime;
	buf[2]=ttime.tms_cutime;
	buf[3]=ttime.tms_cstime;
	buf[4]=CLK_TCK;
	buf[5]=ts.tv_sec;
#ifdef SOLARIS_DONT_USE
	buf[6]=ts.tv_nsec;
#else /* On Linux it's microseconds */
	buf[6]=ts.tv_usec*1000;
#endif
	env->SetLongArrayRegion(aol, 0, 7, buf);

	return aol;
}

}
