package Tools;

import java.io.*;

/**
 * Insert this filter among your <code>OutputStream</code>s to have the
 * data passing through the stream logged with the {@link Log} tool.
 *
 * @classConcise true
 */
public class SnoopyOut extends FilterOutputStream {
	OutputStream is;
	Log log;

	public SnoopyOut(OutputStream out, Log log) {
		super(out);
		this.log = log;
	}

	public void write(int b)
	throws IOException {
		log.log("snoop", ": snoop => 1 = "+b+stream());
		out.write(b);
	}

	public void write(byte b[], int off, int len)
	throws IOException {
		log.log("snoop", ": snoop => ["+len+"@"+off+": "+b[0]+"...]"+stream());
		out.write(b, off, len);
	}

	public void write(byte b[])
	throws IOException {
		log.log("snoop", ": snoop => ["+b.length+": "+b[0]+"...]"+stream());
		out.write(b);
	}

	public String stream() {
		return "  >"+out.toString();
	}

	/**
	 * Send an explicit message to the log.
	 */
	public void comment(String s) {
		// log.log("at offset "+Integer.toHexString(count)+": "+s);
	}
}
