function [polys, sn, exp] = plot_experiment(exp, noSubplots);
% present results for bandwidth experiments

base_experiment = exp.source;
sub_experiments = exp.subex;
range = exp.range;
independent_var = exp.ind.var;
dependent_var = exp.dep.var;

sn = get_experiments(base_experiment);

logplot = isequal(exp.ind.scale, 'log');

samples.xaxis = [];
samples.yaxis = [];
fitline.xaxis = [];
fitline.yaxis = [];
cvs = [];
legend_entry = {};
text_entry = {};
tex_label = {};
tex_report = {};
polys = [];	% One [slope intercept] per experiment
sub_exp_name = 'a'-1;
conf = 0.95;
textExperimentNum = sprintf('Experiment %d', exp.index);
for i=1:length(sub_experiments),
	sub_desc = sub_experiments{i};
	[sn_sub,text_label] = multi_select_experiment(sn, sub_desc);

	xvalues = getfield(sn_sub, independent_var);
	yvalues = getfield(sn_sub, dependent_var)';
	yvalues = yvalues(:);
	if (exp.dep.rawSamples),
		samples.multiplier = length(yvalues)/length(xvalues);
		xsamples = repmat(xvalues(:), 1, samples.multiplier)';
		xsamples = xsamples(:);
	else
		xsamples = xvalues;
	end

	[sns.poly,sns.ci,sns.rr,sns.sigma] = hanyfit(xsamples,yvalues,conf);
	sns.line = polyval(sns.poly, xvalues);

	samples.xaxis = [samples.xaxis, xsamples*exp.ind.axisFactor];
	samples.yaxis = [samples.yaxis, yvalues*exp.dep.factor];
	fitline.xaxis = [fitline.xaxis, xvalues*exp.ind.axisFactor];
	fitline.yaxis = [fitline.yaxis, sns.line*exp.dep.factor];
	cvs = [cvs, sn_sub.cv];

	sub_exp_name = sub_exp_name+1;
	legend_entry = [legend_entry; cellstr(char(sub_exp_name))];
	% legend_entry = [legend_entry; cellstr('lin')];

	polys(i,1).poly = sns.poly;
	polys(i,1).slope = sns.poly(1)*exp.dep.factor/exp.ind.slopeFactor;
	polys(i,1).slope_ci = sns.ci(1)*exp.dep.factor/exp.ind.slopeFactor;
	polys(i,1).y_intercept = sns.poly(2)*exp.dep.factor;
	polys(i,1).y_intercept_ci = sns.ci(2)*exp.dep.factor;
	polys(i,1).sigma = sns.sigma*exp.dep.factor;
	polys(i,1).rr = sns.rr;
	polys(i,1).dep = exp.dep;
	polys(i,1).ind = exp.ind;
	slope_factor = exp.dep.factor/exp.ind.slopeFactor;

	plusMinus = '$\pm$';
	percent = '%';

	sigma_report = ['$\sigma$=',sprintf('%4.1f', sns.sigma*exp.dep.factor), exp.dep.units];
	rr_report = ['$R^{2}$=',sprintf('%0.2f', sns.rr)];
	b0_report = ['$b_{0}$=',sprintf('%5.2f %s %.1f %s', ...
		sns.poly(2)*exp.dep.factor, plusMinus, sns.ci(2)*exp.dep.factor, ...
			exp.dep.units)];
	b1_report = ['$b_{1}$=',sprintf('%5.2f %s %.1f %s/%s', ...
		sns.poly(1)*slope_factor, plusMinus, sns.ci(1)*slope_factor,...
			exp.dep.units, exp.ind.slopeUnits)];
	report_label = [' ', char(sub_exp_name), '  ', text_label, 10 ];
	report = sprintf('   %s %s %s %s',...
		sigma_report, rr_report, b0_report, b1_report);

	% de-LaTeX the report for on-screen display
	screen_report = report(find(report~='$'));
	text_entry = [text_entry; cellstr([report_label, screen_report])];

	% generate .tex file
	tex_label = [tex_label; cellstr(sprintf('%s{%s} & \\multicolumn{4}{l}{%s}\\\\\n', '\textbf', char(sub_exp_name), text_label))];
	row_report = sprintf('   & %s & %s & %s & %s',...
		sigma_report, rr_report, b0_report, b1_report);
	tex_report = [tex_report; cellstr([row_report, sprintf('\\\\\n')])];
end

% squirt resulting observations back into experiment()
% (pre-sorting!)
exp.polys = polys;

% sort data by decreasing y-intercept, so that legend corresponds
% spatially to the plotted lines
y_intercepts = [];
for i=1:length(polys),
	y_intercepts = [y_intercepts; polys(i).y_intercept];
end
[y_junk, sort_order] = sort(y_intercepts);
sort_order = sort_order(end:-1:1);

% now resort the data according to this order.
% what a mess!
samples.xaxis = samples.xaxis(:,sort_order);
samples.yaxis = samples.yaxis(:,sort_order);
fitline.xaxis = fitline.xaxis(:,sort_order);
fitline.yaxis = fitline.yaxis(:,sort_order);
polys = polys(sort_order);
cvs = cvs(:,sort_order);
text_entry = text_entry(sort_order);
legend_entry = legend_entry(sort_order);

tex_label = tex_label(sort_order);
tex_report = tex_report(sort_order);

tex_fid = fopen(sprintf('ps/desc%02d.tex', exp.index), 'w');
fprintf(tex_fid, '\\Experiment{%d}\n', exp.index);
fprintf(tex_fid, '\\StartVariables\n');
fprintf(tex_fid, '%s\n', '\begin{tabular}{lrrrr}');
for i=1:length(tex_label),
	fprintf(tex_fid, '%s', char(tex_label(i)));
	fprintf(tex_fid, '%s', char(tex_report(i)));
end
fprintf(tex_fid, '%s\n', '\end{tabular}');
fprintf(tex_fid, '\\EndVariables\n');

% output the variables that don't change over this experiment
fprintf(tex_fid, '\\StartConstants\n');
fprintf(tex_fid, '\\begin{tabular}{rl}\n');
fprintf(tex_fid, '\\ConstantKill\n');
for i=1:size(sn.propList,1),
	if (prod(size(sn.propList{i,2}))==1),
		val = sn.propList{i,2};
		fprintf(tex_fid, '%s & %s \\\\\n', sn.propList{i,1}, val{1});
	end
end
if (length(findstr(exp.source, 'shovel'))),
	fprintf(tex_fid, '%s & %s \\\\\n', 'network locality', 'local');
else
	fprintf(tex_fid, '%s & %s \\\\\n', 'network locality', 'remote');
end
fprintf(tex_fid, '\\end{tabular}\n');
fprintf(tex_fid, '\\EndConstants\n');
fclose(tex_fid);


figure(1);
clf;
plot_size = [1 2/3];
plot_base = [0 1/3];
ctr = plot_base+plot_size/2;
shrink = 0.80;
pp = [ctr - 0.5*(plot_size*shrink), plot_size*shrink];
if (~noSubplots),
	subplot_graph = subplot('position', pp);
else
	figure(1);
end

% Use logarithmic scale for fileLengthNum, since it spans such a huge range
hold on;
samples.lines = plot(samples.xaxis, samples.yaxis, 'x');
fitline.lines = plot(fitline.xaxis, fitline.yaxis, '-');
hold off;

if (logplot),
	set(gca,'xscale','log');
else
	zeroscale(1,0);
end

xlabel(sprintf('%s (%s)', independent_var, exp.ind.axisUnits));
ylabel(sprintf('%s (%s)', dependent_var, exp.dep.units));

zeroscale(0,1);
set(gca,'ylim',[0 range]);

%set(fitline.lines,'LineStyle',':');	% distinguished the polyfit data
colorOrder = get(gca,'colorOrder');
colorOrder(4,:) = [0.5 0 0.75];
markers = 'xo+d.<';

lines = [samples.lines, fitline.lines];
for i=1:size(lines,1),
	set(lines(i,:)','Color',colorOrder(i,:));
	% mark each data set with a different symbol
	set(lines(i,1)','marker',markers(i))
	%fieldnames(get(lines(i,:)'))
	%get(lines(i,:)','marker')
end
legend(samples.lines, legend_entry, 2);				% label the lines
if (~noSubplots),
	title(base_experiment);
end

if (~noSubplots),
	subplot_text = subplot('position',[0 0 2/3 1/3]);
	%set(subplot_text, 'xtick', [], 'ytick', []);
	axis off
	text_entry = [cellstr(textExperimentNum); text_entry];
	text_handle =text(0,0.5,text_entry,'sc');
	set(text_handle, 'fontsize', get(text_handle,'fontsize')*0.9);
end


plot_size = [1/3 1/3];
plot_base = [2/3 0];
ctr = plot_base+plot_size/2;
shrink = [0.85 0.70];
pp = [ctr - 0.5*(plot_size.*shrink), plot_size.*shrink];
if (~noSubplots),
	subplot_cvs = subplot('position', pp);
else
	figure(2);
end
lines = plot(fitline.xaxis,cvs,'.');
for i=1:length(lines),
	set(lines(i),'Color', colorOrder(i,:));
	set(lines(i),'marker', markers(i));
end
set(gca,'ylim',[0 0.3]);
if (logplot),
	set(gca,'xscale','log');
end
title('CVs');

% generate the presentable version of the observed quantities
exp.b_units = exp.dep.units;
exp.m_units = sprintf('%s/%s', exp.dep.units, exp.ind.slopeUnits);

params = {'slope','y_intercept','slope_ci','y_intercept_ci','rr','sigma'};
paramNicks = {'m','b','mci','bci','rr','sgm'};
paramUnits = {exp.m_units, exp.b_units, exp.m_units, exp.b_units, '', exp.b_units};
exp.summary = [];
if (findstr(exp.source, 'plow')),
	distance = 'rem';
else
	distance = 'loc';
end
for j=1:length(polys),
	poly = exp.polys(j);
	if (length(exp.subnick)>0),
		subnick = char(exp.subnick(j));
	else
		subnick = char(exp.subex{j}(2));
	end
	fieldName = sprintf('%s_%s_%s', ...
		exp.nick, distance, subnick);
	package = [];
	package.value = [];
	package.units = [];
	for k=1:length(params),
		param = char(params(k));
		paramNick = char(paramNicks(k));
		paramUnit = char(paramUnits(k));
		if (length(fieldName)>31),
			error(sprintf('field name will overflow: %s', fieldName));
		end
		package.value = setfield(package.value,paramNick,getfield(poly, param));
		package.units = setfield(package.units,paramNick,paramUnit);
	end
	exp.summary = setfield(exp.summary, fieldName, package);
end

