function [poly, delta, r2] = linfit(x,y,conf)
% jon's linear fit function

error('linfit does not work. I got the conf intervals wrong. hanyfit does work.');

if (length(x) ~= length(y)),
	error('x and y must be same length');
end

n = length(x);

% from page 509 of John A. Rice,
% "Mathematical Statistics and Data Analysis," 2 ed.
denom = n*sum(x.^2)-(sum(x))^2;
b0 = (sum(x.^2)*sum(y)-sum(x)*sum(x.*y)) / denom;

b1 = (n*sum(x.*y)-sum(x)*sum(y)) / denom;

% s2 and rss from p. 512
rss = sum((y-b0-b1*x).^2);
s2 = rss/(n-2);

% s2b0 (p514) = var(b0) (p513)
s2b0 = s2*sum(x.^2) / denom;
s2b1 = n*s2 / denom;
sb0 = sqrt(s2b0);
sb1 = sqrt(s2b1);

t = tinv(conf,n-2);

poly = [b1 b0];
delta = [sb1 sb0]*t;

% goodness = r^2 = ssr/sst (Jain p. 227)
ymean = mean(y);
sst = sum((y-ymean).^2);
r2 = (sst-rss)/sst;
