function [beta, delta, r2, sigma] = hanyfit(x,y,conf)
% hany's matrix linear fit function

if (length(x) ~= length(y)),
	error('x and y must be same length');
end

n = length(x);

% from page 4/9/2000.2
% rice 530ish
x = x(:);
y = y(:);
xm = [x, ones(size(x))];

pinvx = inv(xm'*xm)*xm';
beta = pinvx*y;

yresiduals = y - xm*beta;
yvariance = yresiduals'*yresiduals;
% from rice p. 514. he calls 'yvariance' RSS
sigma2 = yvariance / (n-2);
% we want to report the "standard deviation of errors" -- sigma
sigma = sqrt(sigma2);

xresiduals = x - mean(x);
xvariance = xresiduals'*xresiduals;

varb0 = sigma2 * (x'*x) / (n*xvariance);
varb1 = sigma2 / xvariance;

tparam = tinv(conf,n-2);
delta = tparam*[varb1;varb0];

% rice 539
% p = x*inv(x'*x)*x';

% Jain 227
yresidualsFromMean = y - mean(y);
yvarianceFromMean = yresidualsFromMean'*yresidualsFromMean;
r2 = 1-(yvariance/yvarianceFromMean);
