figure(1);
clf
mid = 0.5;
split = 0.5;
startLow = 0.05;
heightLow = 0.4;
shrink = [0.7 0.8];
makeSlide = 0;		% 0 => make separate plots, for thesis
					% 1 => make single plot, for defense (job talk)

w = 0.5;	% width of bars (see flat_graph.m)

% colors
%blue = [0.20, 0.00, 0.80];
%cyan = [0.00, 0.56, 0.56];
%magenta =[0.69, 0.00, 0.69];
%red =[0.80, 0.00, 0.00];
if (makeSlide),	% slides have color
	blue	= [0 0 1];
	cyan	= [0 1 1];
	magenta	= [1 0 1];
	red		= [1 0 0];
else
	blue	= [1 1 1]*0.50;
	cyan	= [1 1 1]*1.00;
	magenta	= [1 1 1]*0.00;
	red		= [1 1 1]*0.00;
end

bar_defs = {
0,	'sslreq_loc_apache', 'm_value', 'Apache', magenta;
1,	'sslreq_loc_jetty', 'm_value', 'Jetty', magenta;
2,	'sslIIbw_apache_loc_cacSes', 'b_value', 'Apache', magenta;
3,	'sslIIbw_jetty_loc_cacSes', 'b_value', 'Jetty', magenta;
4,	'sslIIbw_apache_loc_full', 'b_value', 'Apache', magenta;
5,	'sslIIbw_jetty_loc_full', 'b_value', 'Jetty', magenta;
6.5,	'sfbw_sh_loc_ident', 'b_value', 'ident', blue;
7.5,	'sfbw_sh_loc_macs', 'b_value', 'MAC', blue;
8.5,	'sfbw_sh_loc_full', 'b_value', 'sign', blue;
10,	'sfserverauth_loc_cacSig', 'b_value', 'cache', cyan;
11,	'sfserverauth_loc_sign', 'b_value', 'sign', cyan;
12,	'sfserverauth_loc_cacChk', 'b_value', 'cache', cyan;
13,	'sfserverauth_loc_sigChk', 'b_value', 'sign', cyan;
};

if (makeSlide),
	trickySubplot([0 split 1 1-split], [0.8 0.8]);
else
	clf;
end
x = defenseSquirtOne(aggexp, bar_defs);
hold on;
set(gca, 'xlim', [min(x)-w, max(x)+w]);
tr1 = -35;
tr2 = -55;
ha = 'HorizontalAlignment';
th = text(10.5,tr1,'ignore'); 					set(th, ha, 'center');
th = text(12.5,tr1,'verify'); 					set(th, ha, 'center');

th = text(0.5,tr1,'request');					set(th, ha, 'center');
th = text(2.5,tr1,'cached sess.');				set(th, ha, 'center');
th = text(4.5,tr1,'new sess.');					set(th, ha, 'center');

th = text(7.5,tr2,'Snowflake client auth.');	set(th, ha, 'center');
th = text(11.5,tr2,'Snowflake server auth.');	set(th, ha, 'center');
th = text(2.5,tr2,'SSL authentication'); 	set(th, ha, 'center');
ylabel('milliseconds');
set(gca,'ytick', [0:100:500]);

% next graph...
if (makeSlide),
	trickySubplot([0 startLow mid heightLow], shrink);
else
	perfGraphSize = [1 1 8 4.5];
	set(gcf,'paperposition',perfGraphSize);
	print(1, '-dps2', 'ps/perf-graph-1.eps');
	clf;
end

bar_defs = {
0,		'fastgetbw_loc_apache', 'b_value', 'C', red;
1,		'httpbw_loc_Jetty', 'b_value', 'Java', magenta;
2,		'sfbw_sh_loc_ident', 'b_value', 'Sf', blue;
};
x = defenseSquirtOne(aggexp, bar_defs);
set(gca, 'xlim', [min(x)-w, max(x)+w]);
hold on;
patch([2-w/2; 2-w/2; 2+w/2; 2+w/2]+w/4, [41; 81; 81; 41], [0 0 0 0], cyan);
th = text(1.9,60.5,strvcat('slow','SPKI','parse','~40ms'));
if (makeSlide),
	set(th,'fontsize',9);
	set(th, 'color', [1 1 1]);	% slides
else
	set(th, 'color', [0 0 0]);	% slides
end
ylabel('milliseconds');

% RMI graph...
if (makeSlide),
	trickySubplot([mid startLow 1-mid heightLow], shrink);
else
	perfGraphSize = [1 1 4 3.0];
	set(gcf,'paperposition',perfGraphSize);
	print(1, '-dps2', 'ps/perf-graph-2.eps');
	clf
end

bar_defs = {
0,		'rmibw_loc_rmi', 'b_value', 'basic RMI', red;
1,		'rmibw_loc_rmissh', 'b_value', 'RMI+ssh', magenta;
2,		'rmibw_loc_rmisf', 'b_value', 'RMI+Sf', blue;
};
x = defenseSquirtOne(aggexp, bar_defs);
set(gca, 'xlim', [min(x)-w, max(x)+w]);
ylabel('milliseconds');

if (makeSlide),
	set(gcf,'paperposition',[1 1 7 9]);
	print(1, '-dps2', 'ps/defense-graphs.ps');
else
	perfGraphSize = [1 1 4 3.0];
	set(gcf,'paperposition',perfGraphSize);
	print(1, '-dps2', 'ps/perf-graph-3.eps');
end
