package timingexp;

import Tools.*;
import java.text.*;

/**
 * A debugging tool. Used to look for big delays in a code path,
 * delays on the order of several milliseconds. Amazing how many such
 * huge delays there are floating around in the {@link sdsi} package
 * and elsewhere.<p>
 *
 * When called from the command line,
 * run all three processes (proxy, mail servlet, secure-database) in a
 * single process, and let them all demarcate times on the same
 * timeline. Of course, this'll screw things up since some ssh/RMI will be
 * optimized away...
 */
public class Timeline {
	public static void main(String[] argv) {
		Thread t1 = new Thread() {
			public void run() {
				jp.ProxyConfig.main(new String[] {"certs-jon"});
			}
		};
			// The principal that the Proxy owns; will control
			// secure files & secure database.
		final String magicHash = "(hash md5 |7G72B2o2Ghj/qlMRx6Vifg==|)";
		Thread t2 = new Thread() {
			public void run() {
				jp.SecureServerConfig.main(new String[] { magicHash });
			}
		};
		Thread t3 = new Thread() {
			public void run() {
				relational.SSHDatabase.main(new String[] { magicHash });
			}
		};
		t3.start();
		t2.start();
		t1.start();
	}

	static Timer timer;
	static double lastTime;
	static { zeroTimer(); }
	public static void zeroTimer() {
		timer = new Timer();
		lastTime = 0.0;
	}

	static NumberFormat nf = null;
	public static NumberFormat getNF() {
		if (nf==null) {
			nf = NumberFormat.getInstance();
			nf.setMaximumFractionDigits(3);
			nf.setMinimumFractionDigits(3);
			nf.setMinimumIntegerDigits(2);
		}
		return nf;
	}
	public static void timePoint(String desc) {
		double time = timer.wallTime();
		double elapsed = time - lastTime;
		lastTime = time;
		System.err.println("@ "+getNF().format(time)
			+" ("+getNF().format(elapsed)
			+")  "+desc);
		timer.unlap();
	}
}
