package ssh;

import ssh.RSA.RSAKey;

/**
 * A Socket that implements this interface can identify the other end
 * of the socket by its public key; it has somehow (generally by
 * checking a signature during key exchange) shown that messages
 * emerging from the socket on this end are spoken for by the public
 * key returned by {@link #getOppositeKey}.
 */
public interface KeyedSocket {
	/**
	 * Return the public key that speaks for messages read from the
	 * local end of the socket.
	 */
	abstract public RSAKey getOppositeKey();
}
