package relational;

import java.util.Hashtable;
import java.util.Vector;
import java.lang.reflect.Field;
import Tools.Text;

/**
 * Invert the sense of a where subclause.
 *
 * @classConcise true
 */
public class WhereNot
	extends Where {
	Where w1;

	public WhereNot() {
	}

	public WhereNot(Where w1) {
		this.w1 = w1;
	}

	public boolean includes(Row ro, Database db) {
		return !w1.includes(ro, db);
	}

	public String toString() {
		return "(not "+w1+")";
	}

	public String indentedString(int d) {
		return "NOT\n"+Text.indent(d, w1.indentedString(d));
	}

	public String getShortName() { return "NOT"; }

	public int getChildCount() {
		return 1;
	}

	public Object getChild(int index) {
		if (index==0) {
			return w1;
		} else {
			throw new IllegalArgumentException(getClass()+" has only 1 child");
		}
	}

	public void setChild(int index, Object child) {
		if (index==0) {
			w1 = (Where) child;
		} else {
			throw new IllegalArgumentException(getClass()+" has only 1 child");
		}
	}
}
