package relational;

import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;

/**
 * A Unix command-line interface to instantiate an InternalDatabase and
 * bind it to a well-known name in the localhost's RMIRegistry.
 */
public class RMIDatabase {
	public static void main(String[] args) {
		try {
			Database theDatabase = new InternalDatabase();
			InetAddress thisHost = InetAddress.getLocalHost();
			Naming.rebind("//"+thisHost.getHostName()+"/RMIDatabase",
				theDatabase);
			System.out.println("Database registered in RMI");
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
