package proof;

import java.util.*;
import sdsi.*;

/**
 * A chain (linked list) of NameNodes stores the series of connections
 * that link a SDSIPrincipal to a "local" key (one we have the private
 * key for).
 *
 * @deprecated part of the original {@link Prover} class.
 * {@link Prover2} is the tool clients should use now.
 */
public abstract class NameNode {
	NameNode next;

	public abstract Vector getNameVector();

	public abstract SDSIPrincipal getPrincipal();

	public int chainLength() {
		return next!=null
			? next.chainLength()+1
			: 1;
	}

	public void debugChain(Prover pr) {
		System.out.println("  "+pr.getName(getPrincipal()));
		if (next!=null) {
			next.debugChain(pr);
		}
	}

	public boolean containsPrincipal(SDSIPrincipal p) {
		if (getPrincipal().equals(p)) {
			return true;
		}
		return next!=null
			? next.containsPrincipal(p)
			: false;
	}

	/**
	 * Should be true if and only if the name chain rooted here
	 * includes at least one DefNameNode.
	 */
	public boolean hasDefs() {
		return next!=null
			? next.hasDefs()
			: false;
	}

	public String toString() {
		Vector v = getNameVector();
		String name = "";
		while (v.size()>0) {
			if (!name.equals("")) {
				name += "'s ";
			}
			name += v.elementAt(v.size()-1);
			v.removeElementAt(v.size()-1);
		}
		return name;
	}
}
