package Tools;

/**
 * A class to give a wordy mnemonic to an otherwise meaningless
 * bitstring (say, a hash value). Returns a string made up of
 * two four-letter words (not like that!), such as ``duke-alma.''
 * There are 1024 words in this class' vocabulary, so a two-word
 * string is a mnemonic with 20 bits of uniqueness.
 */
public class Mnemonic {
	/* make up a mnemonic for the first 20 bits of the byte string */
	public static String get(long word) {
		byte[] b = new byte[8];
		for (int i=0; i<8; i++) {
			b[i] = (byte) (word & 0x0ff);
			word = word>>8;
		}
		return get20(b);
	}

	public static String get20(byte[] bs) {
		byte[] b2 = new byte[3];
		System.arraycopy(bs, 0, b2, 0, Math.min(bs.length, b2.length));
		int val = ((((int) b2[0])&0x0ff) << 12)
				| ((((int) b2[1])&0x0ff) <<  4)
				| ((((int) b2[2])&0x0f0) >>  4);
		// String hexString = Integer.toHexString(val);
		return words1024[val>>10]+"-"+words1024[val&0x03ff]
			// +"["+hexString+"]"
			;
	}

	// The 1024 most-popular four-letter uncapitalized words
	// in /usr/dict/words, sorted by popularity in Google. :v)
	static String[] words1024 = {
// :.+1,$-2!./sortWords.pl
	"have",
	"here",
	"more",
	"also",
	"next",
	"some",
	"only",
	"been",
	"they",
	"your",
	"last",
	"them",
	"were",
	"each",
	"than",
	"time",
	"into",
	"like",
	"many",
	"over",
	"such",
	"then",
	"list",
	"most",
	"very",
	"back",
	"page",
	"date",
	"site",
	"just",
	"well",
	"both",
	"name",
	"good",
	"mail",
	"even",
	"said",
	"must",
	"take",
	"know",
	"full",
	"work",
	"make",
	"part",
	"need",
	"much",
	"open",
	"info",
	"home",
	"want",
	"made",
	"find",
	"read",
	"same",
	"year",
	"view",
	"area",
	"free",
	"form",
	"best",
	"help",
	"come",
	"line",
	"link",
	"down",
	"look",
	"text",
	"long",
	"left",
	"high",
	"data",
	"note",
	"life",
	"type",
	"give",
	"call",
	"post",
	"less",
	"four",
	"file",
	"able",
	"send",
	"size",
	"once",
	"move",
	"city",
	"keep",
	"upon",
	"case",
	"five",
	"done",
	"sure",
	"held",
	"took",
	"main",
	"away",
	"code",
	"week",
	"book",
	"side",
	"real",
	"came",
	"feel",
	"soon",
	"sent",
	"show",
	"hand",
	"went",
	"past",
	"head",
	"play",
	"seen",
	"fall",
	"plus",
	"body",
	"hard",
	"pour",
	"plan",
	"tell",
	"meet",
	"thus",
	"easy",
	"kind",
	"live",
	"cost",
	"love",
	"term",
	"near",
	"fact",
	"copy",
	"item",
	"game",
	"test",
	"true",
	"turn",
	"west",
	"room",
	"wide",
	"team",
	"told",
	"rest",
	"half",
	"stop",
	"road",
	"base",
	"else",
	"talk",
	"gave",
	"rate",
	"word",
	"mark",
	"none",
	"role",
	"mean",
	"bill",
	"lost",
	"hour",
	"shop",
	"care",
	"hold",
	"hope",
	"face",
	"late",
	"land",
	"unit",
	"club",
	"hear",
	"east",
	"save",
	"door",
	"fast",
	"mind",
	"nice",
	"whom",
	"fine",
	"seem",
	"step",
	"sign",
	"onto",
	"idea",
	"card",
	"sale",
	"town",
	"goes",
	"wish",
	"star",
	"kept",
	"fill",
	"deal",
	"blue",
	"park",
	"stay",
	"felt",
	"food",
	"port",
	"lead",
	"pass",
	"knew",
	"load",
	"tech",
	"goal",
	"auto",
	"died",
	"menu",
	"host",
	"tree",
	"join",
	"tend",
	"vice",
	"feet",
	"cool",
	"song",
	"tool",
	"lack",
	"sell",
	"shot",
	"wife",
	"loss",
	"mike",
	"sold",
	"huge",
	"tour",
	"path",
	"till",
	"band",
	"rock",
	"logo",
	"edit",
	"paid",
	"firm",
	"wait",
	"mode",
	"nine",
	"sort",
	"born",
	"chat",
	"hill",
	"king",
	"seek",
	"risk",
	"poor",
	"drop",
	"deep",
	"hall",
	"race",
	"safe",
	"film",
	"pick",
	"trip",
	"mass",
	"male",
	"bank",
	"ball",
	"walk",
	"wall",
	"dark",
	"jump",
	"rich",
	"jean",
	"bien",
	"foot",
	"fund",
	"dead",
	"wire",
	"grow",
	"miss",
	"tout",
	"girl",
	"soft",
	"task",
	"anti",
	"slow",
	"rule",
	"pair",
	"fair",
	"cold",
	"gain",
	"baby",
	"gold",
	"lose",
	"root",
	"edge",
	"core",
	"disk",
	"lord",
	"spot",
	"rose",
	"zone",
	"rise",
	"gone",
	"beat",
	"mine",
	"rare",
	"heat",
	"math",
	"wood",
	"flow",
	"roll",
	"fell",
	"jack",
	"army",
	"wind",
	"cash",
	"cell",
	"toll",
	"kill",
	"gift",
	"warm",
	"cast",
	"wild",
	"ship",
	"draw",
	"fish",
	"drug",
	"fear",
	"pull",
	"inch",
	"vote",
	"alan",
	"demo",
	"solo",
	"cart",
	"fail",
	"duty",
	"flat",
	"exit",
	"dear",
	"grew",
	"lady",
	"zero",
	"wear",
	"golf",
	"busy",
	"void",
	"dial",
	"pool",
	"farm",
	"pack",
	"dean",
	"beta",
	"camp",
	"pure",
	"bell",
	"sans",
	"laid",
	"tape",
	"cook",
	"mere",
	"mini",
	"ease",
	"cafe",
	"soul",
	"seat",
	"lane",
	"bear",
	"fort",
	"luck",
	"vast",
	"suit",
	"tony",
	"tied",
	"vary",
	"mile",
	"rain",
	"sole",
	"ride",
	"yeah",
	"wave",
	"gene",
	"gate",
	"hurt",
	"snow",
	"okay",
	"glad",
	"dell",
	"loop",
	"push",
	"semi",
	"salt",
	"hell",
	"ring",
	"pine",
	"crew",
	"icon",
	"pain",
	"boat",
	"navy",
	"pace",
	"feed",
	"oral",
	"mall",
	"desk",
	"bull",
	"rear",
	"hole",
	"weak",
	"rent",
	"rank",
	"tiny",
	"gear",
	"wash",
	"sera",
	"peak",
	"disc",
	"gray",
	"yard",
	"shut",
	"moon",
	"byte",
	"evil",
	"grad",
	"lieu",
	"dire",
	"skin",
	"ford",
	"kick",
	"tale",
	"fuel",
	"arch",
	"nick",
	"dual",
	"wise",
	"hate",
	"hair",
	"chip",
	"font",
	"loan",
	"rick",
	"earn",
	"exam",
	"bond",
	"surf",
	"thin",
	"viii",
	"flag",
	"rice",
	"peek",
	"acid",
	"slip",
	"hire",
	"lock",
	"tall",
	"bass",
	"hong",
	"plot",
	"iron",
	"bird",
	"wing",
	"keys",
	"scan",
	"tone",
	"hang",
	"noon",
	"grab",
	"skip",
	"echo",
	"spec",
	"blow",
	"diet",
	"quit",
	"mint",
	"hide",
	"nova",
	"hunt",
	"pink",
	"sand",
	"sing",
	"lift",
	"sick",
	"visa",
	"dick",
	"teen",
	"poll",
	"neck",
	"loud",
	"flew",
	"twin",
	"tune",
	"bath",
	"jazz",
	"mill",
	"null",
	"bold",
	"tank",
	"harm",
	"span",
	"thou",
	"nose",
	"duke",
	"stud",
	"dale",
	"prod",
	"sake",
	"snap",
	"wine",
	"meat",
	"dawn",
	"meal",
	"bowl",
	"spin",
	"cure",
	"plug",
	"grey",
	"soil",
	"drew",
	"fold",
	"fare",
	"burn",
	"ante",
	"wore",
	"gilt",
	"aide",
	"welt",
	"tail",
	"char",
	"ward",
	"cape",
	"fate",
	"deny",
	"rush",
	"cute",
	"bare",
	"debt",
	"acre",
	"hero",
	"mess",
	"nude",
	"pose",
	"dust",
	"bout",
	"seal",
	"bulk",
	"roof",
	"alto",
	"palm",
	"folk",
	"cite",
	"boot",
	"bike",
	"worn",
	"jest",
	"dose",
	"brad",
	"deck",
	"gang",
	"urge",
	"neat",
	"wake",
	"pray",
	"bone",
	"chef",
	"mild",
	"stir",
	"drag",
	"clay",
	"node",
	"leaf",
	"tube",
	"hung",
	"reed",
	"beer",
	"bent",
	"pipe",
	"memo",
	"coat",
	"quiz",
	"wrap",
	"yang",
	"boss",
	"milk",
	"sexy",
	"gulf",
	"kiss",
	"rail",
	"calm",
	"clip",
	"dirt",
	"hook",
	"damn",
	"thee",
	"reel",
	"vita",
	"pole",
	"peer",
	"fond",
	"dare",
	"glen",
	"belt",
	"poem",
	"slam",
	"geld",
	"blew",
	"zoom",
	"dice",
	"wolf",
	"jury",
	"beam",
	"mood",
	"crop",
	"bean",
	"bomb",
	"fork",
	"tile",
	"hint",
	"grid",
	"obey",
	"norm",
	"joke",
	"pale",
	"dove",
	"fame",
	"foil",
	"mate",
	"mask",
	"earl",
	"hart",
	"fled",
	"cope",
	"horn",
	"swim",
	"beth",
	"poet",
	"ugly",
	"seed",
	"vent",
	"fest",
	"bite",
	"pump",
	"bend",
	"prep",
	"tear",
	"luke",
	"boil",
	"dock",
	"boom",
	"bald",
	"lion",
	"slot",
	"trim",
	"drum",
	"shed",
	"deja",
	"heal",
	"cock",
	"lest",
	"tilt",
	"hood",
	"pity",
	"halt",
	"bush",
	"rack",
	"buck",
	"sang",
	"jail",
	"vain",
	"barn",
	"lust",
	"warp",
	"suck",
	"soup",
	"ware",
	"knee",
	"vivo",
	"nest",
	"bias",
	"dish",
	"atom",
	"warn",
	"keen",
	"corn",
	"stem",
	"flip",
	"trap",
	"cord",
	"swap",
	"lamp",
	"troy",
	"ping",
	"emma",
	"bind",
	"dent",
	"novo",
	"sail",
	"sink",
	"butt",
	"duly",
	"feat",
	"grin",
	"oven",
	"wage",
	"hull",
	"tent",
	"woke",
	"oval",
	"grip",
	"tier",
	"lien",
	"trek",
	"torn",
	"conn",
	"herb",
	"dame",
	"myth",
	"watt",
	"shaw",
	"dash",
	"harp",
	"idle",
	"leap",
	"axis",
	"bolt",
	"aura",
	"loin",
	"dump",
	"tray",
	"lazy",
	"volt",
	"trio",
	"pond",
	"buzz",
	"sage",
	"duck",
	"pile",
	"gaze",
	"heel",
	"coal",
	"rage",
	"coin",
	"flux",
	"lucy",
	"herd",
	"bang",
	"dank",
	"foul",
	"cave",
	"tome",
	"isle",
	"shoe",
	"chin",
	"silk",
	"hast",
	"mesh",
	"lens",
	"prop",
	"wert",
	"levy",
	"soap",
	"melt",
	"lime",
	"clue",
	"beef",
	"alma",
	"lung",
	"bake",
	"mart",
	"hath",
	"lean",
	"rope",
	"cage",
	"fade",
	"deer",
	"berg",
	"mare",
	"mice",
	"pope",
	"homo",
	"junk",
	"fake",
	"fist",
	"lend",
	"crow",
	"glue",
	"dumb",
	"coup",
	"aqua",
	"lamb",
	"cake",
	"slid",
	"cult",
	"beck",
	"babe",
	"lawn",
	"kirk",
	"eyed",
	"dull",
	"lone",
	"aunt",
	"soda",
	"bore",
	"funk",
	"heck",
	"taxi",
	"vale",
	"dine",
	"moss",
	"hike",
	"dome",
	"sank",
	"iris",
	"sung",
	"punk",
	"fool",
	"doll",
	"slim",
	"tire",
	"vein",
	"tide",
	"quad",
	"ramp",
	"pike",
	"saga",
	"jake",
	"toss",
	"rang",
	"vise",
	"papa",
	"cove",
	"polo",
	"chap",
	"wade",
	"hack",
	"joey",
	"amid",
	"clan",
	"mesa",
	"turk",
	"crap",
	"vase",
	"epic",
	"mist",
	"leer",
	"ruin",
	"gill",
	"dive",
	"punt",
	"gore",
	"swan",
	"glow",
	"atop",
	"leak",
	"rape",
	"khan",
	"hail",
	"aver",
	"kern",
	"omit",
	"plea",
	"curb",
	"slut",
	"cone",
	"cant",
	"hose",
	"heed",
	"deed",
	"ding",
	"hawk",
	"fore",
	"neon",
	"bred",
	"bump",
	"pest",
	"sour",
	"guru",
	"rust",
	"foam",
	"nail",
	"soak",
	"tore",
	"bust",
	"holt",
	"peel",
	"tate",
	"lace",
	"ruby",
	"deem",
	"doom",
	"tomb",
	"coop",
	"frog",
	"sore",
	"indy",
	"lisp",
	"raid",
	"prey",
	"lynx",
	"bark",
	"viva",
	"vine",
	"mack",
	"spur",
	"tara",
	"mold",
	"pulp",
	"weed",
	"hale",
	"cola",
	"rude",
	"ibid",
	"tick",
	"lily",
	"amen",
	"coil",
	"heft",
	"mort",
	"hash",
	"zinc",
	"pier",
	"sunk",
	"beau",
	"axle",
	"worm",
	"cube",
	"maze",
	"lick",
	"oath",
	"mast",
	"lame",
	"tack",
	"gala",
	"muse",
	"rein",
	"wool",
	"turf",
	"whip",
	"rave",
	"fury",
	"wipe",
	"eddy",
	"lied",
	"brew",
	"cork",
	"sigh",
	"gale",
	"flex",
	"ally",
	"sack",
	"pork",
	"yell",
	"coke",
	"lure",
	"reef",
	"maid",
	"cane",
	"germ",
	"chop",
	"wilt",
	"fuse",
	"hank",
	"slew",
	"womb",
	"bash",
	"sect",
	"lava",
	"monk",
	"pont",
	"deaf",
	"tang",
	"hoop",
	"slug",
	"bury",
	"scar",
	"mock",
	"zeal",
	"bait",
	"rend",
	"knot",
	"snip",
	"limb",
	"heir",
	"coca",
	"mitt",
	"jeep",
	"pact",
	"damp",
	"verb",
	"grim",
	"lush",
	"goat",
	"crab",
	"envy",
	"helm",
	"curt",
	"mana",
	"knit",
	"hare",
	"idol",
	"anew",
	"ripe",
	"pony",
	"chew",
	"comb",
	"alba",
	"veto",
	"lore",
	"puck",
	"apex",
	"slag",
	"haul",
	"brow",
	"hymn",
	"pill",
	"bulb",
	"bona",
	"jade",
	"rash",
	"dole",
	"rata",
	"barb",
	"flee",
	"lump",
	"riot",
	"spun",
	"axes",
	"dusk",
	"emit",
	"scam",
	"vide",
	"rote",
	"buff",
	"sofa",
	"fuss",
	"alum",
	"tuna",
	"fern",
	};
}
