package timingexp;

import java.io.*;

/**
 * A debugging class used to ensure that the Test RMI interface was
 * really transmitting the bytes it claimed to be transmitting.
 */
public class TestResult
	implements Serializable {

	byte[] message;
	int checksum;

	public TestResult(byte[] buf) {
		message = buf;
		checksum = cheesyChecksum(message);
	}

	public void verify() {
		int checksum2 = cheesyChecksum(message);
		if (checksum2 != checksum) {
			System.err.println("oh noooo! "+checksum+"!="+checksum2);
		} else {
			System.err.println("oh boooy! "+checksum+"=="+checksum2
				+" length="+message.length);
		}
	}

	public static int cheesyChecksum(byte[] b) {
		int sum = 0;
		for (int i=0; i<b.length; i++) {
			int val = b[i]&0x0ff;
			int shift = i&0x07;
			sum = sum ^ ((val<<shift) | (val>>shift));
		}
		return sum;
	}
}
