package ssh;

import ssh.*;
import ssh.RSA.*;

import java.io.*;
import java.math.*;

/**
 * This simple class just tests using SSH as a raw, link protocol,
 * without any ``authentication'' that the public key on the other end
 * is meaningful. That's how we use SSH in Snowflake; Snowflake proofs
 * take care of showing that the keys have authority.
 */
public class SRPTest {
	public static void main(String args[]) {
		new SRPTest().realMain();
	}
	
	PipedInputStream pis1, pis2;
	PipedOutputStream pos1, pos2;
	SecureRMIProtocol client, server;
	SshRandom random;

	public void realMain() {
		try {
			random = new SshRandom();

			pis1 = new PipedInputStream();
			pos1 = new PipedOutputStream(pis1);

			pis2 = new PipedInputStream();
			pos2 = new PipedOutputStream(pis2);
	
			client = new SecureRMIProtocol();
			server = new SecureRMIProtocol();

			new Thread() {
				public void run() {
					System.out.println("Client thread attempting to connect.");
					try {
						RSAKey[] keys = ssh.RSA.Keygen.generateKeys(768, random);
						client.setKey(keys[0], keys[1]);
						client.connect(pis1, pos2);
						System.out.println(client.getInputStream().read());
					} catch (IOException ex) {
						ex.printStackTrace();
					}
				}
			}.start();
	
			new Thread() {
				public void run() {
					System.out.println("Server thread attempting to connect.");
					try {
						RSAKey[] keys = ssh.RSA.Keygen.generateKeys(768, random);
						server.setKey(keys[0], keys[1]);
						server.accept(pis2, pos1);
						server.getOutputStream().write('Y');
						server.getOutputStream().flush();
					} catch (IOException ex) {
						ex.printStackTrace();
					}
				}
			}.start();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}
}
