package servlet;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

/**
 * This exception is related to {@link jp.PageException} in that it
 * encapsulates an exception and knows how to send that exception to
 * the client via a response object.  @todo In fact, this exception
 * class should probably be merged with PageException.
 */
public class StatusCodeException
	extends RuntimeException {

	int code;

	/**
	 * Create an exception with the given code.
	 *
	 * @param code One of the SC_ constants defined in {@link
	 * java.servlet.HttpServletResponse}.
	 * @param msg a textual error message
	 */
	public StatusCodeException(int code, String msg) {
		super(msg);
		this.code = code;
	}

	/**
	 * Send the exception as an HTTP error to the client.
	 */
	public void sendError(HttpServletResponse response)
		throws IOException {
		response.sendError(code, toString());
	}
}
