package sdsi;

import sdsi.sexp.*;

/**
 * The interface of all TagExpressions, the parts that make
 * up a given Tag. This is the real 'meaty' datatype, a Tag (the
 * publicly available interface, and exportable object) is just (tag
 * ...) wrapped around a structure of TagExpressions.
 */
interface TagExpression
	extends java.io.Serializable {
	/**
	 * Return a TagExpression that represents the intersection of this
	 * one and the <code>otherTE</code> argument.
	 *
	 * <p>
	 * This method implies n^2 relationships among the n implementors
	 * of TagExpression. To avoid duplication of effort, we exploit the
	 * symmetry (commutativity) of the intersect operation to divide
	 * the n^2 combinations of classes into a triangle by imposing a
	 * partial order on the implementors of TagExpression, and allowing
	 * any class to defer its implementation of intersect to the
	 * otherTE argument when otherTE belongs to a previous class in the
	 * partial order.
	 *
	 * Here is the order so far:
	 * {TENull, TEStar, TESet} can intersect with anything
	 *	< {TEPrefix, TERange} defer sometimes to TESet
	 *	< {TEList} defers whenever otherTE is TESpecial
	 *			(which encompasses the first two groups)
	 *	< {TEByteString} defers whenever it can
	 * 			(whenever otherTE isn't a TEByteString.)
	 */
	public abstract TagExpression intersect(TagExpression otherTE);

	/**
	 * Analogous to SDSIObject.getSrep(), but not all TagExpressions
	 * are represented by a SexpList.
	 */
	public abstract Sexp getSexp()
		throws NullTagException;
}
