package relational;

import java.util.Hashtable;
import java.util.Vector;
import java.lang.reflect.Field;

/**
 * Join two tables together where two fields are equal.
 *
 * @classConcise true
 */
public class WhereJoin
	extends Where {
	FieldDescriptor f1;
	FieldDescriptor f2;

	public WhereJoin(FieldDescriptor f1, FieldDescriptor f2) {
		this.f1 = f1;
		this.f2 = f2;
	}

	public boolean includes(Row ro, Database db) {
		Tools.Assert.assert(f1!=null && f2!=null);
		return f1.get(ro).equals(f2.get(ro));
	}

	public String toString() {
		String fieldName1 = (f1!=null) ? f1.toString() : "(null)";
		String fieldName2 = (f2!=null) ? f2.toString() : "(null)";
		return "("+fieldName1+" =J "+fieldName2+")";
	}

	public String indentedString(int d) {
		String fieldName1 = (f1!=null) ? f1.toString() : "(null)";
		String fieldName2 = (f2!=null) ? f2.toString() : "(null)";
		return "JOIN "+fieldName1+"\n= "+fieldName2;
	}

	public int getChildCount() {
		return 2;
	}

	public Object getChild(int index) {
		if (index==0) {
			return f1;
		} else if (index==1) {
			return f2;
		} else {
			throw new IllegalArgumentException("WhereJoin has only 2 children");
		}
	}

	public void setChild(int index, Object child) {
		if (index==0) {
			f1 = (FieldDescriptor) child;
		} else if (index==1) {
			f2 = (FieldDescriptor) child;
		} else {
			throw new IllegalArgumentException("WhereJoin has only 2 children");
		}
	}

	public String getShortName() { return " =J "; }
}
