package relational;

import java.io.Serializable;

/**
 * A Row packages up objects that form a row of results; it can be
 * accessed by a ColumnSpec requesting specific columns.
 */
public interface Row
	extends Serializable {
	public Relational getTable(FromClause fc, int table);
	public Object getField(int tableIndex, FieldDescriptor fd);
	public Object getField(FieldDescriptor fd);
	public ColumnSpec getColumnSpec();
	public boolean supports(ColumnSpec cs);
	public FromClause getFromClause();
		// returns null if this row doesn't have a FromClause. That is,
		// it's only meaningful on rows that are made up of concatenated
		// Relational objects, rather than just a subset of fields from
		// the object.
		// The FromClause is useful for extracting a table index and
		// then getting the table itself out. That operation is meaningless
		// on Rows that aren't made up of concatenated tables, hence
		// we don't feel bad about return null.
	public Relational getTable(Class c);
	public Relational getTable(String tableName);
}
