package relational;

import java.io.Serializable;
import java.rmi.RemoteException;

/**
 * The Database that serves a DirectRelational object (row) is stored
 * as a reference in a field along with each such object.
 */
public abstract class DirectRelational
	extends Relational {

	Database db;
	static int seq = 0;

	public DirectRelational(Database db) {
		setDatabase(db);
		setPrimaryKey(new Integer(seq++));
	}

	public Database getDatabase() {
		return db;
	}

	public void setDatabase(Database db) {
		this.db = db;
	}
}
