package proof;

import java.io.*;
import java.util.*;
import java.security.*;

import sdsi.*;
import proof.*;
import servlet.*;
import Tools.*;

/**
 * An authenticator closure that employs an Authorization certificate
 * when needed to show authority over the issuer. It works by including
 * the auth certificate in the reply, plus recursing to find a proof
 * that the caller speaks for the subject of the certificate.
 *
 * @deprecated part of the original {@link Prover} class.
 * {@link Prover2} is the tool clients should use now.
 */
public class UseAuth
	implements AuthClosure {

	SignedCertificate sc;

	public UseAuth(SignedCertificate sc) {
		this.sc = sc;
		Assert.assert(sc.getCertificate() instanceof Auth);
	}

	public boolean equals(Object o) {
		if (o instanceof UseAuth) {
			return ((UseAuth) o).sc.equals(this.sc);
		}
		return false;
	}

	public int hashCode() {
		return sc.hashCode();
	}

	/**
	 * Who would you need to speak for in order to make use of my
	 * auth certificate?
	 */
	public Subject getSubject() {
		return getAuth().getSubject();
	}

	public Subject getIssuer() {
		return getAuth().getIssuer();
	}

	Auth getAuth() {
		return (Auth) sc.getCertificate();
	}

	/**
	 * The Auth itself is the proof that subject speaks for issuer.
	 */
	public Proof getProof(SDSIPrincipal issuer, Subject subject) {
		// It should be the case that issuer is the issuer of
		// this.auth, and that the subject speaks for this.auth.subject.

		Assert.assert(issuer.equals(getIssuer()));
		Assert.assert(subject.equals(getSubject()));
		return new SignedCertificateProof(sc);
	}

	public boolean isUsefulForAuth(Tag authTag) {
		return getAuth().getTag().hasSubset(authTag);
	}
}
