#
# build-tree-specific configurations
#
HOST = $(shell hostname)

ifeq ($(HOST),plow.cs.dartmouth.edu)
HOST = shovel.cs.dartmouth.edu
endif

ifeq ($(HOST),shovel.cs.dartmouth.edu)

# shovel
PROJECT_ROOT=/u/jonh/snowflake

# The Java Development Kit
#	I think tools.jar is where the compiler lives. (?)
JDK_CLASSES=/usr/local/jdk/classes:/usr/local/jdk/lib/tools.jar

# We use these vendor packages:
#	Jetty (Java webserver, with servlet holder)
#	cryptix (crypto providers)
##	PureTLS (free Java SSL implementation from claymore systems)
##  (only for SSL comparison tests, now -- I couldn't easily make it work well under RMI)
## 	TexDoclet :/u/jonh/texdoclet/doclet.jar
VENDOR_CLASSES=/u/jonh/Jetty-2.3.3/src:/u/jonh/cryptix/build/classes:/u/jonh/puretls-0.9b1/src

# Unused classes:
#	WBI
#	Sun's JSDK (Jetty provides all that.)
WBI_CLASSES=/u/jonh/wbij43/lib/ras.jar:/u/jonh/wbij43/lib/wbij43.jar:/u/jonh/wbij43/lib/xml4j.jar
JSDK_CLASSES=/usr/local/JSDK2.0/lib/jsdk.jar

# EXTRACLASSPATH may be defined in a subdirectory's makefile.

CLASSPATH=$(PROJECT_ROOT):$(JDK_CLASSES):$(VENDOR_CLASSES):$(EXTRACLASSPATH)
JAVA_INCLUDES=/usr/local/jdk/include:/usr/local/jdk/include/solaris

else

# laptop
PROJECT_ROOT=/home/jonh/snowflake
JDK_CLASSES=
C_LIBS=
JAVA_INCLUDES=/usr/local/java/jdk1.2.2/include:/usr/local/java/jdk1.2.2/include/solaris
CLASSPATH=$(PROJECT_ROOT):$(JDK_CLASSES)

endif

include $(PROJECT_ROOT)/makerules.mk
