package Tools;

import java.io.*;

/**
 * An OutputStreamFilter that counts the number of bytes written.
 */
public class CountingFilterOutputStream
	extends FilterOutputStream {

	long count=0;

	public CountingFilterOutputStream(OutputStream out) {
		super(out);
	}

	/**
	 * @returns how many bytes have passed through this stream since it
	 * was created.
	 */
	public long getCount() {
		return count;
	}

	public void write(int b) throws IOException {
		out.write(b);
		count++;
	}
	
	public void write(byte b[]) throws IOException {
		out.write(b);
		count+=b.length;
	}

	public void write(byte b[], int off, int len) throws IOException {
		out.write(b, off, len);
		count+=len;
	}
}
