fileLength.var = 'fileLengthNum';
fileLength.axisUnits = 'bytes';
fileLength.axisFactor = 1;
fileLength.slopeUnits = 'MB';
fileLength.slopeFactor = 1/(1024*1024);	% bytes => MB
fileLength.scale = 'log';

requestsPerConnection.var = 'requestsPerConnectionNum';
requestsPerConnection.axisUnits = 'req';
requestsPerConnection.axisFactor = 1;
requestsPerConnection.slopeUnits = 'req';
requestsPerConnection.slopeFactor = 1;
requestsPerConnection.scale = 'linear';

msPerRequest.var = 'timePerRequest';
msPerRequest.units = 'ms';
msPerRequest.factor = 1000;			% sec => ms
msPerRequest.rawSamples = 1;		% need multiple copies of each x value,
									% since we're displaying raw samples.

% msPerRequest.var = 'meanPerRequest';
% msPerRequest.rawSamples = 0;

msPerConn.var = 'timePerConnection';
msPerConn.units = 'ms';
msPerConn.factor = 1000;			% sec => ms
msPerConn.rawSamples = 1;

%%% The Snowflake bandwidth experiment

experiment(1).name = 'Snowflake bandwidth';
experiment(1).nick = 'sfbw_sh';
experiment(1).subex = {
	{'identicalRequests','true','useMacs','true','authenticateServer','false'},
	{'identicalRequests','false','useMacs','true','authenticateServer','false'},
	{'identicalRequests','false','useMacs','false','authenticateServer','false'}};
experiment(1).subnick = {'ident','macs','full'};
experiment(1).range = 650;
experiment(1).ind = fileLength;
experiment(1).dep = msPerRequest;

experiment(2) = experiment(1);

% experiment(1).source = 'timedata/snowflake-shovel-bw';
% experiment(2).source = 'timedata/snowflake-plow-bw';
% experiment(1).source = 'timedata/snowflake-shovel-withsign';
% experiment(2).source = 'timedata/snowflake-plow-close';
% experiment(1).source = 'timedata/snowflake-shovel-withauth';
% experiment(2).source = 'timedata/snowflake-plow-withauth';
experiment(1).source = 'timedata/snowflake-authz-shovel2';
experiment(2).source = 'timedata/snowflake-authz-plow2';

%%% The HTTP bandwidth experiment
experiment(3).name = 'HTTP Bandwidth';
experiment(3).nick = 'httpbw';
experiment(3).source = 'timedata/http-shovel-bw';
experiment(3).subex = { ...
	{'server','apache'}, {'server','simple'}, {'server', 'Jetty'}
	};
experiment(3).range = 150;
experiment(3).ind = fileLength;
experiment(3).dep = msPerRequest;

experiment(4) = experiment(3);
experiment(4).source = 'timedata/http-plow-bw';

%%% The SSL bandwidth experiment
sub_experiments(1).ex = {...
	{'server','apache','cacheContext','true','cacheSessions','true'}, ...
	{'server','apache','cacheContext','true','cacheSessions','false'}, ...
	{'server','apache','cacheContext','false','cacheSessions','false'}, ...
	};
sub_experiments(2).ex = {...
	{'server','simple','cacheContext','true','cacheSessions','true'}, ...
	{'server','simple','cacheContext','true','cacheSessions','false'}, ...
	{'server','simple','cacheContext','false','cacheSessions','false'}, ...
	};
sub_experiments(3).ex = {...
	{'server','Jetty','cacheContext','true','cacheSessions','true'}, ...
	{'server','Jetty','cacheContext','true','cacheSessions','false'}, ...
	{'server','Jetty','cacheContext','false','cacheSessions','false'}, ...
	};

experiment(5).name = 'SSL Bandwidth';
experiment(5).source = 'timedata/ssl-shovel-bw';
experiment(5).subnick = {'cacSes','cacCon','full'};
experiment(5).range = 3500;
experiment(5).ind = fileLength;
experiment(5).dep = msPerRequest;

experiment(6) = experiment(5);
experiment(7) = experiment(5);

experiment(5).subex = sub_experiments(1).ex;
experiment(5).nick = 'sslbw_apache';
experiment(6).subex = sub_experiments(2).ex;
experiment(6).nick = 'sslbw_simple';
experiment(7).subex = sub_experiments(3).ex;
experiment(7).nick = 'sslbw_jetty';

%%% The SSL request time experiment
experiment(8).name = 'SSL Request Time';
experiment(8).nick = 'sslreq';
experiment(8).source = 'timedata/sslreq3-shovel-3';
experiment(8).subex = {...
	{'server','apache','fileLength','000100'}, ...
	{'server','Jetty', 'fileLength','000100'}, ...
	};
experiment(8).subnick = {'apache','jetty'};
experiment(8).range = 5000;
experiment(8).ind = requestsPerConnection;
experiment(8).dep = msPerConn;

experiment(9) = experiment(8);
experiment(9).source = 'timedata/sslreq3-plow-3';

% There should be a way to extract from this data the cost of
% a new 0-byte connection. But I didn't spend enough time to figure it out.
% It's kinda linear in two variables (reqPerConn, fileLength)

%%% The HTTP1.1 request time experiment
%%% (How much do you save by reusing a socket?)
experiment(10).name = 'HTTP/1.1 Request Time';
experiment(10).nick = 'httpIIreq';
experiment(10).source = 'timedata/11req-shovel';
experiment(10).subex = experiment(8).subex;
experiment(10).subnick = experiment(8).subnick;
experiment(10).range = 750;
experiment(10).ind = requestsPerConnection;
experiment(10).dep = msPerConn;

experiment(11) = experiment(10);
experiment(11).source = 'timedata/11req-plow';

%%% The SSL context/session setup experiment
experiment(12).name = 'SSL context/session setup';
experiment(12).nick = 'sslsetup';
experiment(12).source = 'timedata/sslsetup2-shovel';
experiment(12).subex = {...
	{'cacheContext','true','cacheSessions','true'}, ...
	{'cacheContext','true','cacheSessions','false'}, ...
	{'cacheContext','false','cacheSessions','false'}, ...
	};
experiment(12).subnick = {'cacSes','cacCon','full'};
experiment(12).range = 2500;
experiment(12).ind = requestsPerConnection;
experiment(12).dep = msPerConn;

%%% re-done SSL bandwidth experiments using HTTP/1.1 consistently
experiment(13).name = 'SSL Bandwidth with HTTP/1.1';
experiment(13).source = 'timedata/sslbw11-shovel-3';
experiment(13).subnick = experiment(5).subnick;
experiment(13).range = 3500;
experiment(13).ind = fileLength;
experiment(13).dep = msPerRequest;

experiment(14) = experiment(13);
experiment(13).subex = sub_experiments(1).ex;
experiment(13).nick = 'sslIIbw_apache';
experiment(14).subex = sub_experiments(3).ex;
experiment(14).nick = 'sslIIbw_jetty';

experiment(15) = experiment(13);
experiment(15).source = 'timedata/sslbw11-plow-3';
experiment(15).subex = sub_experiments(1).ex;
experiment(15).nick = 'sslIIbw_apache';

experiment(16) = experiment(15);
experiment(16).subex = sub_experiments(3).ex;
experiment(16).nick = 'sslIIbw_jetty';

% The C client (fastget) experiments
experiment(17).name = 'dumb C (fastget) client, HTTP/1.0';
experiment(17).nick = 'fastgetbw';
experiment(17).source = 'timedata/fastget-shovel-bw';
experiment(17).range = 10;
experiment(17).ind = fileLength;
experiment(17).dep = msPerRequest;
experiment(17).subex = {{'server', 'apache'}};

experiment(18) = experiment(17);
experiment(18).source = 'timedata/fastget-plow-bw';
experiment(18).range = 100;

%%% The Snowflake signing (server authentication) experiment

experiment(19).name = 'Snowflake server authentication';
experiment(19).nick = 'sfserverauth';
experiment(19).subex = {
	{'authenticateServer','false','signFiles','false','cacheSigns','false'},
	{'authenticateServer','false','signFiles','true','cacheSigns','false'},
	{'authenticateServer','false','signFiles','true','cacheSigns','true'},
	{'authenticateServer','true','signFiles','true','cacheSigns','false'},
	{'authenticateServer','true','signFiles','true','cacheSigns','true'}};
experiment(19).subnick = {'none','sign','cacSig','sigChk','cacChk'};
experiment(19).range = 800;
experiment(19).ind = fileLength;
experiment(19).dep = msPerRequest;

experiment(20) = experiment(19);

experiment(19).source = 'timedata/snowflake-signs-shovel4';
experiment(20).source = 'timedata/snowflake-signs-plow4';

% weird case
experiment(21).name = 'weird chunky snowflake case';
experiment(21).nick = 'weird';
experiment(21).source = 'timedata/snowflake-weird-plow';
experiment(21).range = 250;
experiment(21).ind = fileLength;
experiment(21).dep = msPerRequest;
experiment(21).subex = {{'cacheSigns', 'true'}};	% some true test

% try experiment 1, subex 3 with linear data
experiment(22) = experiment(1);
experiment(22).source = 'timedata/snowflake-authzlin-shovel3';
experiment(22).subex = experiment(1).subex(3);
experiment(22).nick = 'sfbw_sh_lin';

%%%% RMI+ssh experiments

experiment(23).name = 'RMI bandwidth';
experiment(23).nick = 'rmibw';
experiment(23).source = 'timedata/rmibw-shovel-5';
experiment(23).range = 600;
experiment(23).ind = fileLength;
experiment(23).ind.scale = 'linear';
experiment(23).dep = msPerRequest;
experiment(23).subex = {
	{'registryService', 'TestRMIServer0'},
	{'registryService', 'TestRMIServer2'},
	{'registryService', 'TestRMIServer3'}
	};	% some true test
experiment(23).subnick = {'rmi','rmissh','rmisf'};

experiment(24) = experiment(23);
experiment(24).source = 'timedata/rmibw-plow-6';

%%%% RMI+ssh setup

experiment(25).name = 'RMI ssh setup';
experiment(25).nick = 'rmisetup';
experiment(25).source = 'timedata/rmisetup-shovel-3';
experiment(25).range = 1200;
experiment(25).ind = fileLength;
experiment(25).dep = msPerRequest;
experiment(25).subex = {
	{'clientCachesProofs', 'false', 'serverCachesProofs', 'false'},
	{'clientCachesProofs', 'true', 'serverCachesProofs', 'false'},
	{'clientCachesProofs', 'true', 'serverCachesProofs', 'true'}
	};
experiment(25).subnick = {'nocache','clientcache','servercache'};

experiment(26) = experiment(25);
experiment(26).source = 'timedata/rmisetup-plow-4';

%experiment(27).name = 'RMI ssh setup2';
%experiment(27).nick = 'rmisetupTwo';
%experiment(27).source = 'timedata/rmisetup2-shovel-1';
%experiment(27).range = 200;
%experiment(27).ind = fileLength;
%experiment(27).dep = msPerRequest;
%experiment(27).subex = {
%	{'clientCachesProofs', 'true', 'serverCachesProofs', 'true', 'borrowingAllowed', 'false', 'cacheRMIConnections', 'false', 'registryService', 'TestRMIServer2'},
%	{'clientCachesProofs', 'true', 'serverCachesProofs', 'true', 'borrowingAllowed', 'true', 'cacheRMIConnections', 'false', 'registryService', 'TestRMIServer2'},
%	{'clientCachesProofs', 'true', 'serverCachesProofs', 'true', 'borrowingAllowed', 'true', 'cacheRMIConnections', 'true', 'registryService', 'TestRMIServer2'},
%	{'clientCachesProofs', 'true', 'serverCachesProofs', 'true', 'borrowingAllowed', 'false', 'cacheRMIConnections', 'false', 'registryService', 'TestRMIServer3'},
%	{'clientCachesProofs', 'true', 'serverCachesProofs', 'true', 'borrowingAllowed', 'true', 'cacheRMIConnections', 'false', 'registryService', 'TestRMIServer3'},
%	{'clientCachesProofs', 'true', 'serverCachesProofs', 'true', 'borrowingAllowed', 'true', 'cacheRMIConnections', 'true', 'registryService', 'TestRMIServer3'},
%	{'clientCachesProofs', 'false', 'serverCachesProofs', 'false', 'borrowingAllowed', 'false', 'cacheRMIConnections', 'false', 'registryService', 'TestRMIServer3'},
%	{'clientCachesProofs', 'true', 'serverCachesProofs', 'false', 'borrowingAllowed', 'false', 'cacheRMIConnections', 'false', 'registryService', 'TestRMIServer3'},
%	};
%experiment(27).subnick = {'sshfull','sshborrow','sshrmicache', 'sffull','sfborrow','sfrmicache','sfclientcache','sfservercache'};

% number the experiments
for i=1:length(experiment),
	experiment(i).index = i;
end
