package ssh;

import java.io.*;

/**
 * A StdinPasswordAuthenticator asks the user for his password
 * (on stdin) when it is required. Note that Java has no provision for
 * turning off echoing of characters on stdin.<p>
 * 
 * Source: for ssh protocol definition:
 * draft-ylonen-ssh-protocol-00.txt especially pages 13, 21.
 *
 * @author Jon Howell <jonh@cs.dartmouth.edu>
 * @rcs $Id: StdinPasswordAuthenticator.java,v 1.3 2000/05/26 06:17:35 jonh Exp $
 * @license This code is Copyright 1999 Jon Howell. It is available for
 * use under the GNU Public License, available at:
 * http://www.gnu.org/copyleft/gpl.html
 */
public class StdinPasswordAuthenticator
	extends PasswordAuthenticator {

	public StdinPasswordAuthenticator() {
		super(null);
	}

	public void authenticate(BinaryPacketInputStream binaryIn,
							BinaryPacketOutputStream binaryOut)
		throws IOException {
		System.err.println("Password:");
		password = new BufferedReader(new InputStreamReader(System.in))
						.readLine();
		super.authenticate(binaryIn, binaryOut);
	}
}
