
package ssh;

/**
 * This interface puts constant definitions into the scope of
 * any class that 'implements' it. SRP is short for Secure RMI Protocol,
 * by which I mean RMI-over-ssh.
 *
 * @rcs $Id: SRPConstants.java,v 1.3 2000/05/22 01:35:54 jonh Exp $
 * @author Jon Howell <jonh@cs.dartmouth.edu>
 *
 * @license This code is Copyright 1999 Jon Howell. It is available for
 * use under the GNU Public License, available at:
 * http://www.gnu.org/copyleft/gpl.html 
 */
public interface SRPConstants {
		// packet structure definitions.
		// data types are same as specified in draft-ylonen, pages 6-7;
		// for convenience we define the shorthand structured type
		// `rsakey' that stands for
		// int		bits
		// mpint	exponent
		// mpint	modulus

		// This is a cheesy protocol to save a key exchange when setting
		// up a second or later socket between the same two endpoints.
		// TODO: I'm only marginally convinced of its security; for sure
		// it weakens things somewhat by reusing the same session key
		// for more data.
		// This packet is sent instead of SRP_SMSG_SERVER_KEY to indicate
		// that we should reuse "the" existing session key for our pair
		// of endpoints; it's assumed that both ends are in sync about
		// which that key that is. (Probably a silly assumption, and
		// subject to race conditions.) After this packet is sent/received,
		// the session immediately moves into the encrypted state.
		//
		// For this protocol to work, the client is the one likely to
		// know if a session key is reusable, since it knows both
		// the unique server port and the other sessions with that port
		// that it has been involved in. Therefore, we modify the protocol
		// to have the client send the first message, indicating how it
		// wants to authenticate the channel.
	static final int SRP_CMSG_BORROW_SESSION_KEY = 45;
		// int		sessionKeyHash			md5(sessionKey).hashCode()
		// identifies the sessionKey to borrow

	static final int SRP_CMSG_KEY_EXCHANGE = 46;
		// don't borrow a key; start normal key exchange.
		// Server should send SRP_SMSG_SERVER_KEY next.

	static final int SRP_SMSG_SUCCESS = 47;
		// borrowed key acceptable
		// if borrowed key unacceptable, SRP_SMSG_SERVER_KEY follows.
		// If sent, this is the last packet sent in the clear.
		// Client should sent SRP_CMSG_SUCCESS, encrypted, to demonstrate
		// that session key is alive and working.

	static final int SRP_SMSG_SERVER_KEY = 41;
		// byte		SRP_SMSG_SERVER_KEY
		// rsakey	serverKey
		// int		protocolFlags			currently undefined
		// int		supportedCipherMask		|= SRP_CIPHER_*
		// mpint	clientChallenge

	static final int SRP_CMSG_CLIENT_KEY = 42;
		// byte		SRP_CMSG_RESPONSE
		// rsakey	clientKey
		// mpint	eClientChallenge		E(clientKey^-1,clientChallenge)
		// mpint	serverChallenge
		// byte		selectedCipher			SRP_CIPHER_*

	static final int SRP_SMSG_SESSION_KEY = 43;
		// byte		SRP_SMSG_SESSION_KEY
		// mpint	eServerChallenge		E(serverKey^-1,serverChallenge)
		// mpint	eSessionKey				E(clientKey,sessionKey)
		// int		sessionKeyHash			md5(sessionKey).hashCode()
				// sessionKeyHash is used to identify this session key
				// for reuse in a second session w/o a key exchange;
				// it gets sent in cleartext, but doesn't reveal any
				// info about the session key itself. (Although reuse
				// of the session key this way likely makes the key itself
				// more attackable.)

	static final int SRP_CMSG_SUCCESS = 44;
		// byte		SRP_CMSG_SUCCESS

	static final byte SRP_CIPHER_IDEA = 1;
}
