package sdsi;

import sdsi.sexp.*;

/**
 * A PseudoPrincipal is not meant to be used in any real statements.
 * Instead, it's a ``space'' in a prototype statement to be filled in by
 * a recipient to make a concrete statement.
 */
public class PseudoPrincipal
	extends SDSIPrincipal
	implements Subject {

	String description;

	public static final String LABEL = "pseudo-principal";

	/**
	 * Parse an S-expression into a pseudo-principal.
	 *
	 * @param sexplist An SexpList to parse into a PseudoPrincipal subject.
	 * @param nameContext the principal to whom any names specified in
	 * the sexplist are meaningful.
	 */
	public PseudoPrincipal(SexpList sexplist, SDSIPrincipal nameContext)
		throws SexpParseException {

		super(sexplist);
		if (!sexplist.getType().equals(LABEL)) {
			throw new SexpParseException("Not a "+LABEL+" subject");
		}
		if (!(sexplist.size() == 2)
			|| !(sexplist.elementAt(1) instanceof SexpString)) {
			throw new
				SexpParseException("Incorrectly formatted "+LABEL+" subject");
		}
		description = ((SexpString) sexplist.elementAt(1)).stringContent();
	}

	/**
	 * Create a PseudoPrincipal.
	 * 
	 * @param description a textual description that can hint to a
	 * human what principal should take the place of this stand-in
	 * object.
	 */
	public PseudoPrincipal(String description)
		throws SexpParseException {

		this.description = description;
		SexpList sexplist = (new SexpList())
			.append(LABEL)
			.append(description);
		srep = sexplist;
	}

	/**
	 * Return the textual description of what real principal belongs
	 * here.
	 */
	public String getDescription() { return description; }

	public String toShortString() {
		return "("+description+")";
	}
}	
