package relational.email;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

/**
 * A DisplayManager that organizes the GUI in separate windows. There
 * is exactly one command window; each Message gets a new window. I
 * think I had in mind that one could preserve existing queries by
 * creating new queries in new windows (that display the corresponding
 * index view of the results of the query).
 */
public class WindowDisplayManager
	implements DisplayManager {

	WindowDisplayManager() {
		frames = new Vector();
	}

	public void add(JComponent c, String title) {
		JFrame theFrame = new JFrame(title);

		theFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				Window w = e.getWindow();
				w.setVisible(false);
				w.dispose();
				System.exit(0);	//ouch
			}
		});

		theFrame.setLocation(200+100*frames.size(), 100+50*frames.size());
		theFrame.setSize(c.getPreferredSize());

		theFrame.getContentPane().add(c, BorderLayout.CENTER);
		frames.addElement(theFrame);
	}

	Vector frames;

	public void setVisible(boolean state) {
		Enumeration e = frames.elements();
		while (e.hasMoreElements()) {
			((JFrame) e.nextElement()).setVisible(state);
		}
	}

	public void registerKeyboardAction(ActionListener a, String s,
		KeyStroke k, int c) {
		Enumeration e = frames.elements();
		while (e.hasMoreElements()) {
			JFrame theFrame = (JFrame) e.nextElement();
			JComponent contentPane = ((JComponent) theFrame.getContentPane());
			contentPane.registerKeyboardAction(a, s, k, c);
		}
	}

	public FilterView getFilterView() {
		return null;
		// yet another way in which this mgr is broken.
	}
	public MessageView getMessageView() {
		return null;
		// yet another way in which this mgr is broken.
	}
}
