package relational.email;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.tree.*;
import relational.*;

/**
 * WhereTreeCellEditor.java A customized editor for my whereClause
 * tree. swiped from O'Reilly Java Swing ch 17. 
 */
public class WhereTreeCellEditor implements TreeCellEditor {

  EditorComboBox nodeEditor;
  EditorTextField leafEditor;
  CellEditor currentEditor;

  static String[] whereNames = {
		"AND", "=", "Always"
		// TODO: constants until I actually use
		// this code again and need to clean it up
	};

    public WhereTreeCellEditor() {

        EditorTextField tf = new EditorTextField();
        tf.setFont(new Font("Monospaced", Font.PLAIN, 14));
        EditorComboBox cb = new EditorComboBox(whereNames);
        cb.setFont(new Font("Monospaced", Font.PLAIN, 14));

        nodeEditor = cb;
        leafEditor = tf;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value,
                                                boolean isSelected,
                                                boolean expanded,
                                                boolean leaf, int row) {
		if (value instanceof Where) {
			currentEditor = nodeEditor;
			nodeEditor.setSelectedItem(((Where)value).getShortName());
		} else {
        	currentEditor = leafEditor;
			leafEditor.setText(value.toString());
        }
        return (Component)currentEditor;
    }

    public Object getCellEditorValue() {
      return currentEditor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject event) {
      return currentEditor.isCellEditable(event);
    }

    public boolean shouldSelectCell(EventObject event) {
      return currentEditor.shouldSelectCell(event);
    }

    public boolean stopCellEditing() {
      return currentEditor.stopCellEditing();
    }

    public void cancelCellEditing() {
      currentEditor.cancelCellEditing();
    }

    public void addCellEditorListener(CellEditorListener l) {
      nodeEditor.addCellEditorListener(l);
      leafEditor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
      nodeEditor.removeCellEditorListener(l);
      leafEditor.removeCellEditorListener(l);
    }
}
