package relational.email;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;
// import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.io.*;
import relational.*;

/**
 * A JTable that lets the user drag objects. We use it to let the user
 * drag a field in the index view onto the filter window, so he can
 * quickly specify a query by example.
 */
class DragTable
	extends JTable
	implements DragGestureListener, DragSourceListener {

	public DragTable(TableModel tm) {
		super(tm);

		DragSource dragSource = DragSource.getDefaultDragSource();

		dragSource.createDefaultDragGestureRecognizer(
					this, // component where drag originates
					DnDConstants.ACTION_COPY_OR_MOVE, // actions
					this); // drag gesture recognizer
	}

//	static class DummyCellEditor implements TableCellEditor {
//		public Component getTableCellEditorComponent(JTable table,
//			Object value, boolean isSelected, int row, int column) {
//				return null;
//		}
//    	public Object getCellEditorValue() { return null; }
//    	public boolean isCellEditable(EventObject anEvent) { return false; }
//    	public boolean shouldSelectCell(EventObject anEvent) { return false; }
//    	public boolean stopCellEditing() { return true; }
//    	public void cancelCellEditing() { }
//    	public void addCellEditorListener(CellEditorListener l) { }
//    	public void removeCellEditorListener(CellEditorListener l) { }
//	};
//	TableCellEditor dummyCellEditor = new DummyCellEditor();
//
//	protected void processMouseEvent(MouseEvent e) {
//		int id = e.getID();
//		switch(id) {
//			case MouseEvent.MOUSE_PRESSED:
//				System.out.println("processMouseEvent: mousePressed(e)");
//				break;
//			case MouseEvent.MOUSE_RELEASED:
//				System.out.println("processMouseEvent: mouseReleased(e)");
//				break;
//			case MouseEvent.MOUSE_CLICKED:
//				System.out.println("processMouseEvent: mouseClicked(e)");
//				break;
//			case MouseEvent.MOUSE_EXITED:
//				System.out.println("processMouseEvent: mouseExited(e)");
//				break;
//			case MouseEvent.MOUSE_ENTERED:
//				System.out.println("processMouseEvent: mouseEntered(e)");
//				break;
//			default:
//				System.out.println("processMouseEvent: bizarre event");
//		}
//		super.processMouseEvent(e);
//	}
//
//	public void addMouseMotionListener(MouseMotionListener l) {
//		System.err.println("add...: "+l);
//		if (l instanceof javax.swing.plaf.basic.BasicTableUI$MouseInputHandler) {
//			
//			System.err.println("HAHAHHHAHAH! DENIED!!!");
//		} else {
//			super.addMouseMotionListener(l);
//		}
//	}
//
//	public void removeMouseMotionListener(MouseMotionListener l) {
//		System.err.println("remove...: "+l);
//		super.removeMouseMotionListener(l);
//	}

	public void dragGestureRecognized(DragGestureEvent e) {
		// send a fake mouseReleased event to the UI.
		((DragTableUI) getUI()).dragStarted();

		// tweak the table to prevent the UI from selecting other cells
		// during the drag
		// cellEditor = dummyCellEditor;

		// drag anything ...
		Point org = e.getDragOrigin();
		int col = convertColumnIndexToModel(columnAtPoint(org));
		int row = rowAtPoint(org);
		FilterModel fm = (FilterModel) getModel();
		String columnName = fm.getColumnName(col);
		Object value = fm.getValueAt(row, col);
		Where filter = new WhereIn(
				Message.f_primaryKey,
				new Select(Header.f_msg,
					Where.and(
						Where.equals(Header.f_name, columnName),
						new WhereLike(Header.f_value, value.toString())
					)
				)
			);
		e.startDrag(DragSource.DefaultCopyDrop, // cursor
			new TransferableFilter(filter), // transferable
			this);  // drag source listener
	}

	public void dragDropEnd(DragSourceDropEvent e) {}
	public void dragEnter(DragSourceDragEvent e) {}
	public void dragExit(DragSourceEvent e) {}
	public void dragOver(DragSourceDragEvent e) {}
	public void dropActionChanged(DragSourceDragEvent e) {}

	public String getFilename() {
		return "draggy diggery doo";
	}
}
