package relational;

import java.util.Hashtable;
import java.util.Vector;
import java.lang.reflect.Field;

/**
 * Test for equality between two fields (neither operand is a literal).
 *
 * @classConcise true
 */
public class WhereEquals
	extends WhereLiteral {
	FieldDescriptor fd;
	Object o;

	public WhereEquals(FieldDescriptor fd, Object o) {
		this.fd = fd;
		this.o = o;
	}

	public boolean includes(Row ro, Database db) {
		Tools.Assert.assert(fd!=null && o!=null);
		return fd.get(ro).equals(o);
	}

	public String toString() {
		String fieldName = (fd!=null) ? fd.toString() : "(null)";
		return "("+fieldName+"="+o+")";
	}

	public String indentedString(int d) {
		return fd+" = "+o.toString();
	}

	public int getChildCount() {
		return 2;
	}

	public Object getChild(int index) {
		if (index==0) {
			return fd;
		} else if (index==1) {
			return o;
		} else {
			throw new IllegalArgumentException("WhereEquals has only 2 children");
		}
	}

	public void setChild(int index, Object child) {
		if (index==0) {
			fd = (FieldDescriptor) child;
		} else if (index==1) {
			o = child;
		} else {
			throw new IllegalArgumentException("WhereEquals has only 2 children");
		}
	}

	public FieldDescriptor getFieldDescriptor() {
		return fd;
	}

	public String getShortName() { return "="; }
}
