package proof;

import proof.*;
import sdsi.*;

/**
 * A closure (an object whose relevant part is a code snippet) to be
 * stored in a map in ProxyHandler. An instance is called upon to
 * provide authorization for some Snowflake request in-progress.
 *
 * @deprecated part of the original {@link Prover} class.
 * {@link Prover2} is the tool clients should use now.
 */
public interface AuthClosure {
	/**
	 * Who would you need to speak for in order to make use of my
	 * auth certificate?
	 */
	public Subject getSubject();

	/**
	 * Who this auth speaks for, or null if meaningless.
	 * (this method initially installed for debugging porpoises.)
	 */
	public Subject getIssuer();

	/**
	 * Return a proof that the subject speaks for the issuer.
	 */
	public Proof getProof(SDSIPrincipal issuer, Subject subject);

	/**
	 * Return true if this closure can produce a proof that includes
	 * all authorizations specified by authTag. That is,
	 * <pre>
	 *	getProof().getTag().hasSubset(authTag)
	 * </pre>
	 * will be true if and only if this method is true.
	 */
	public boolean isUsefulForAuth(Tag authTag);
}
