/*
 * (c) Copyright IBM Corp. 2005 All Rights Reserved
 *
 * Physical Memory Information Module
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * at your option any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/**
 * @file parsers.h
 *
 * @brief Definitions for the analyzers of the physical memory structures.
 *
 * This part provides the source for the literal values, global variables,
 * and structures for the physical memory analyzer parsers.
 *
 * @author International Business Machines
 * @author Paul Movall <movall@us.ibm.com>
 *
 * @version Current Version: 1.0
 *
 * @date Current Date: 01/2005
 *
 * @version 0.1, 11/2003: File created by Paul Movall <movall@us.ibm.com>
 * @version 1.0, 01/2005: Miscellaneous cleanup for publish
 *
 */

/**
 * @struct parsers_struct
 * @brief The basic structure used to define a parser.
 */
/**
 * @typedef parsers_t
 * @brief Typedef for the parsers_struct structure.
 */
typedef struct parsers_struct {
    char name[80];		/**< Name to display on the parser menu. */
    void (*func)(FILE *);	/**< Function to call for this parser.	 */
} parsers_t;

/* These are documented where they are implemented. */
extern void base_info(FILE *);
extern void base_vma(FILE *);
extern void nonshared_libs(FILE *);
extern void phys_count(FILE *);
extern void dump_phys_pages(FILE *);
extern void lib_summary(FILE *);
extern void lib_sizes(FILE *);

/** @brief The table of available parsers.				*/
parsers_t parsers[] = {
    { .name = "Basic Information (p/v)",
      .func = base_info, },
    { .name = "Basic Information with VMA detail",
      .func = base_vma, },
    { .name = "Library Summary with Maps",
      .func = lib_summary, },
    { .name = "Library Memory Usage Across All Processes (p/v)",
      .func = lib_sizes, },
    { .name = "Non-shared Library Pages",
      .func = nonshared_libs, },
    { .name = "Count physical pages",
      .func = phys_count, },
    { .name = "Dump all physical pages",
      .func = dump_phys_pages, },
};

/** @def MAX_PARSERS The maximum number of parsers available.		*/
#define MAX_PARSERS (sizeof(parsers) / sizeof(parsers_t))

